/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute.options;

import java.util.Map;
import org.jclouds.cloudsigma.domain.AffinityType;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.scriptbuilder.domain.Statement;

public class CloudSigmaTemplateOptions
extends TemplateOptions
implements Cloneable {
    public static final CloudSigmaTemplateOptions NONE = new CloudSigmaTemplateOptions();
    private AffinityType diskDriveAffinity = AffinityType.HDD;

    public CloudSigmaTemplateOptions diskDriveAffinity(AffinityType diskDriveAffinity) {
        this.diskDriveAffinity = diskDriveAffinity;
        return this;
    }

    public AffinityType getDiskDriveAffinity() {
        return this.diskDriveAffinity;
    }

    public CloudSigmaTemplateOptions clone() {
        CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof CloudSigmaTemplateOptions) {
            CloudSigmaTemplateOptions cTo = (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(to);
            cTo.diskDriveAffinity(this.getDiskDriveAffinity());
        }
    }

    public CloudSigmaTemplateOptions blockOnPort(int port, int seconds) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.blockOnPort(port, seconds));
    }

    public CloudSigmaTemplateOptions inboundPorts(int ... ports) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.inboundPorts(ports));
    }

    public CloudSigmaTemplateOptions authorizePublicKey(String publicKey) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.authorizePublicKey(publicKey));
    }

    public CloudSigmaTemplateOptions installPrivateKey(String privateKey) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.installPrivateKey(privateKey));
    }

    public CloudSigmaTemplateOptions blockUntilRunning(boolean blockUntilRunning) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.blockUntilRunning(blockUntilRunning));
    }

    public CloudSigmaTemplateOptions dontAuthorizePublicKey() {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.dontAuthorizePublicKey());
    }

    public CloudSigmaTemplateOptions nameTask(String name) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.nameTask(name));
    }

    public CloudSigmaTemplateOptions runAsRoot(boolean runAsRoot) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.runAsRoot(runAsRoot));
    }

    public CloudSigmaTemplateOptions runScript(Statement script) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.runScript(script));
    }

    public CloudSigmaTemplateOptions overrideLoginCredentials(LoginCredentials overridingCredentials) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.overrideLoginCredentials(overridingCredentials));
    }

    public CloudSigmaTemplateOptions overrideLoginPassword(String password) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.overrideLoginPassword(password));
    }

    public CloudSigmaTemplateOptions overrideLoginPrivateKey(String privateKey) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.overrideLoginPrivateKey(privateKey));
    }

    public CloudSigmaTemplateOptions overrideLoginUser(String loginUser) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.overrideLoginUser(loginUser));
    }

    public CloudSigmaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.overrideAuthenticateSudo(authenticateSudo));
    }

    public CloudSigmaTemplateOptions userMetadata(Map<String, String> userMetadata) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.userMetadata(userMetadata));
    }

    public CloudSigmaTemplateOptions userMetadata(String key, String value) {
        return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(super.userMetadata(key, value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CloudSigmaTemplateOptions that = (CloudSigmaTemplateOptions)o;
        return this.diskDriveAffinity == that.diskDriveAffinity;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.diskDriveAffinity != null ? this.diskDriveAffinity.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "CloudSigmaTemplateOptions{diskDriveAffinity=" + (Object)((Object)this.diskDriveAffinity) + '}';
    }

    public static class Builder {
        public static CloudSigmaTemplateOptions diskDriveAffinity(AffinityType diskDriveAffinity) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return options.diskDriveAffinity(diskDriveAffinity);
        }

        public static CloudSigmaTemplateOptions inboundPorts(int ... ports) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(options.inboundPorts(ports));
        }

        public static CloudSigmaTemplateOptions blockOnPort(int port, int seconds) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(options.blockOnPort(port, seconds));
        }

        public static CloudSigmaTemplateOptions installPrivateKey(String rsaKey) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(options.installPrivateKey(rsaKey));
        }

        public static CloudSigmaTemplateOptions authorizePublicKey(String rsaKey) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(options.authorizePublicKey(rsaKey));
        }

        public static CloudSigmaTemplateOptions userMetadata(Map<String, String> userMetadata) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return (CloudSigmaTemplateOptions)CloudSigmaTemplateOptions.class.cast(options.userMetadata((Map)userMetadata));
        }

        public static CloudSigmaTemplateOptions overrideLoginUser(String user) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return options.overrideLoginUser(user);
        }

        public static CloudSigmaTemplateOptions overrideLoginPassword(String password) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return options.overrideLoginPassword(password);
        }

        public static CloudSigmaTemplateOptions overrideLoginPrivateKey(String privateKey) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return options.overrideLoginPrivateKey(privateKey);
        }

        public static CloudSigmaTemplateOptions overrideAuthenticateSudo(boolean authenticateSudo) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return options.overrideAuthenticateSudo(authenticateSudo);
        }

        public static CloudSigmaTemplateOptions overrideLoginCredentials(LoginCredentials credentials) {
            CloudSigmaTemplateOptions options = new CloudSigmaTemplateOptions();
            return options.overrideLoginCredentials(credentials);
        }
    }
}

