/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.features;

import javax.ws.rs.core.Response;
import org.jclouds.dynect.v3.DynECTApi;
import org.jclouds.dynect.v3.domain.CreatePrimaryZone;
import org.jclouds.dynect.v3.domain.Job;
import org.jclouds.dynect.v3.internal.BaseDynECTApiExpectTest;
import org.jclouds.dynect.v3.parse.DeleteZoneChangesResponseTest;
import org.jclouds.dynect.v3.parse.DeleteZoneResponseTest;
import org.jclouds.dynect.v3.parse.GetZoneResponseTest;
import org.jclouds.dynect.v3.parse.ListZonesResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ZoneApiExpectTest")
public class ZoneApiExpectTest
extends BaseDynECTApiExpectTest {
    HttpRequest get;
    HttpResponse getResponse;
    HttpRequest create;
    HttpResponse createResponse;
    HttpRequest list;
    HttpResponse listResponse;
    HttpRequest deleteChanges;
    HttpResponse deleteChangesResponse;
    HttpRequest delete;
    HttpResponse deleteResponse;
    HttpRequest publish;
    HttpRequest freeze;
    HttpRequest thaw;

    public ZoneApiExpectTest() {
        this.get = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/Zone/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.getResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/get_zone.json", "application/json"))).build();
        this.create = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api2.dynect.net/REST/Zone/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Accept", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).payload(ZoneApiExpectTest.stringPayload("{\"rname\":\"jimmy@jclouds.org\",\"serial_style\":\"increment\",\"ttl\":3600}"))).build();
        this.createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/new_zone.json", "application/json"))).build();
        this.list = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api2.dynect.net/REST/Zone").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/list_zones.json", "application/json"))).build();
        this.deleteChanges = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://api2.dynect.net/REST/ZoneChanges/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Accept", new String[]{"application/json"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.deleteChangesResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/delete_zone_changes.json", "application/json"))).build();
        this.delete = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("DELETE").endpoint("https://api2.dynect.net/REST/Zone/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Accept", new String[]{"application/json"})).addHeader("Content-Type", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).build();
        this.deleteResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/delete_zone.json", "application/json"))).build();
        this.publish = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://api2.dynect.net/REST/Zone/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Auth-Token", new String[]{this.authToken})).payload(ZoneApiExpectTest.stringPayload("{\"publish\":true}"))).build();
        this.freeze = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://api2.dynect.net/REST/Zone/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Accept", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).payload(ZoneApiExpectTest.stringPayload("{\"freeze\":true}"))).build();
        this.thaw = ((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("PUT").endpoint("https://api2.dynect.net/REST/Zone/jclouds.org").addHeader("API-Version", new String[]{"3.3.8"})).addHeader("Accept", new String[]{"application/json"})).addHeader("Auth-Token", new String[]{this.authToken})).payload(ZoneApiExpectTest.stringPayload("{\"thaw\":true}"))).build();
    }

    public void testGetWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.get, this.getResponse);
        Assert.assertEquals((String)success.getZoneApi().get("jclouds.org").toString(), (String)new GetZoneResponseTest().expected().toString());
    }

    public void testCreateWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.create, this.createResponse);
        Assert.assertEquals((Object)success.getZoneApi().scheduleCreate(CreatePrimaryZone.builder().fqdn("jclouds.org").contact("jimmy@jclouds.org").build()), (Object)Job.success((long)285351593L));
    }

    public void testCreateWithContactWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.create, this.createResponse);
        Assert.assertEquals((Object)success.getZoneApi().scheduleCreateWithContact("jclouds.org", "jimmy@jclouds.org"), (Object)Job.success((long)285351593L));
    }

    public void testGetWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.get, this.notFound);
        Assert.assertNull((Object)fail.getZoneApi().get("jclouds.org"));
    }

    public void testListWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.list, this.listResponse);
        Assert.assertEquals((String)success.getZoneApi().list().toString(), (String)new ListZonesResponseTest().expected().toString());
    }

    public void testDeleteChangesWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.deleteChanges, this.deleteChangesResponse);
        Assert.assertEquals((String)success.getZoneApi().deleteChanges("jclouds.org").toString(), (String)new DeleteZoneChangesResponseTest().expected().toString());
    }

    public void testDeleteWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.delete, this.deleteResponse);
        Assert.assertEquals((String)success.getZoneApi().delete("jclouds.org").toString(), (String)new DeleteZoneResponseTest().expected().toString());
    }

    public void testDeleteWhenResponseIs404() {
        DynECTApi fail = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.delete, this.notFound);
        Assert.assertNull((Object)fail.getZoneApi().delete("jclouds.org"));
    }

    public void testPublishWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.publish, this.getResponse);
        Assert.assertEquals((String)success.getZoneApi().publish("jclouds.org").toString(), (String)new GetZoneResponseTest().expected().toString());
    }

    public void testFreezeWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.freeze, this.deleteResponse);
        Assert.assertEquals((String)success.getZoneApi().freeze("jclouds.org").toString(), (String)new DeleteZoneResponseTest().expected().toString());
    }

    public void testThawWhenResponseIs2xx() {
        DynECTApi success = (DynECTApi)this.requestsSendResponses(this.createSession, this.createSessionResponse, this.thaw, this.deleteResponse);
        Assert.assertEquals((String)success.getZoneApi().thaw("jclouds.org").toString(), (String)new DeleteZoneResponseTest().expected().toString());
    }
}

