/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.Domain;
import org.jclouds.glesys.domain.DomainRecord;
import org.jclouds.glesys.features.DomainApi;
import org.jclouds.glesys.internal.BaseGleSYSApiExpectTest;
import org.jclouds.glesys.options.AddDomainOptions;
import org.jclouds.glesys.options.AddRecordOptions;
import org.jclouds.glesys.options.DomainOptions;
import org.jclouds.glesys.options.UpdateRecordOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DomainApiExpectTest")
public class DomainApiExpectTest
extends BaseGleSYSApiExpectTest {
    public void testListDomainsWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/domain_list.json"))).build())).getDomainApi();
        Domain expected = Domain.builder().domainName("testglesys.jclouds.org").createTime(this.dateService.iso8601SecondsDateParse("2012-01-31T12:19:03+01:00")).build();
        Domain actual = (Domain)Iterables.getOnlyElement((Iterable)api.list());
        Assert.assertEquals((String)expected.getName(), (String)actual.getName());
        Assert.assertEquals((Object)expected.getCreateTime(), (Object)actual.getCreateTime());
    }

    public void testListDomainsWhenResponseIs4xxReturnsEmpty() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        Assert.assertTrue((boolean)api.list().isEmpty());
    }

    public void testListDomainRecordsWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/listrecords/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"testglesys.jclouds.org"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/domain_list_records.json"))).build())).getDomainApi();
        ImmutableSet expected = ImmutableSet.of((Object)DomainRecord.builder().id("224538").domainname("testglesys.jclouds.org").host("@").type("NS").data("ns1.namesystem.se.").ttl(3600).build(), (Object)DomainRecord.builder().id("224539").domainname("testglesys.jclouds.org").host("@").type("NS").data("ns2.namesystem.se.").ttl(3600).build(), (Object)DomainRecord.builder().id("224540").domainname("testglesys.jclouds.org").host("@").type("NS").data("ns3.namesystem.se.").ttl(3600).build(), (Object)DomainRecord.builder().id("224541").domainname("testglesys.jclouds.org").host("@").type("A").data("127.0.0.1").ttl(3600).build(), (Object)DomainRecord.builder().id("224542").domainname("testglesys.jclouds.org").host("www").type("A").data("127.0.0.1").ttl(3600).build(), (Object)DomainRecord.builder().id("224543").domainname("testglesys.jclouds.org").host("mail").type("A").data("79.99.4.40").ttl(3600).build(), (Object[])new DomainRecord[]{DomainRecord.builder().id("224544").domainname("testglesys.jclouds.org").host("@").type("MX").data("10 mx01.glesys.se.").ttl(3600).build(), DomainRecord.builder().id("224545").domainname("testglesys.jclouds.org").host("@").type("MX").data("20 mx02.glesys.se.").ttl(3600).build(), DomainRecord.builder().id("224546").domainname("testglesys.jclouds.org").host("@").type("TXT").data("v=spf1 include:spf.glesys.se -all").ttl(3600).build()});
        Set actual = api.listRecords("testglesys.jclouds.org");
        Assert.assertEquals((Set)actual, (Set)expected);
        for (DomainRecord result : actual) {
            for (DomainRecord expect : expected) {
                if (!result.equals((Object)expect)) continue;
                Assert.assertEquals((String)result.toString(), (String)expect.toString(), (String)"Deep comparison using toString() failed!");
            }
        }
    }

    public void testListDomainRecordsWhenResponseIs4xxReturnsEmpty() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/list/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        Assert.assertTrue((boolean)api.list().isEmpty());
    }

    public void testAddDomainRecordsWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/addrecord/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"jclouds.org"}).addFormParam("host", new String[]{"jclouds.org"}).addFormParam("type", new String[]{"A"}).addFormParam("data", new String[]{""}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/domain_record.json", "application/json"))).build())).getDomainApi();
        Assert.assertEquals((Object)api.createRecord("jclouds.org", "jclouds.org", "A", "", new AddRecordOptions[0]), (Object)this.recordInDomainRecord());
    }

    protected DomainRecord recordInDomainRecord() {
        return DomainRecord.builder().id("256151").domainname("cl13016-domain.jclouds.org").host("test").type("A").data("127.0.0.1").ttl(3600).build();
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testAddDomainRecordsWhenResponseIs4xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/addrecord/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"jclouds.org"}).addFormParam("host", new String[]{"jclouds.org"}).addFormParam("type", new String[]{"A"}).addFormParam("data", new String[]{""}).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        api.createRecord("jclouds.org", "jclouds.org", "A", "", new AddRecordOptions[0]);
    }

    public void testUpdateDomainRecordsWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/updaterecord/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("recordid", new String[]{"256151"}).addFormParam("host", new String[]{"somehost"}).addFormParam("ttl", new String[]{"1800"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/domain_record.json", "application/json"))).build())).getDomainApi();
        Assert.assertEquals((Object)api.updateRecord("256151", UpdateRecordOptions.Builder.host((String)"somehost").ttl(1800)), (Object)this.recordInDomainRecord());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testUpdateDomainRecordsWhenResponseIs4xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/updaterecord/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("recordid", new String[]{"256151"}).addFormParam("host", new String[]{"somehost"}).addFormParam("ttl", new String[]{"1800"}).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        api.updateRecord("256151", UpdateRecordOptions.Builder.host((String)"somehost").ttl(1800));
    }

    public void testDeleteDomainRecordsWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/deleterecord/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("recordid", new String[]{"256151"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/domain_record.json", "application/json"))).build())).getDomainApi();
        api.deleteRecord("256151");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testDeleteDomainRecordsWhenResponseIs4xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/deleterecord/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("recordid", new String[]{"256151"}).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        api.deleteRecord("256151");
    }

    public void testGetDomainWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/details/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"cl66666_x"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/domain_details.json", "application/json"))).build())).getDomainApi();
        Assert.assertEquals((Object)api.get("cl66666_x"), (Object)this.domainInDomainDetails());
    }

    public void testGetDomainWhenResponseIs4xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/details/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"cl66666_x"}).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        Assert.assertNull((Object)api.get("cl66666_x"));
    }

    protected Domain domainInDomainDetails() {
        return Domain.builder().domainName("cl13016-domain.jclouds.org").createTime(this.dateService.iso8601SecondsDateParse("2012-06-24T11:52:49+02:00")).recordCount(9).build();
    }

    public void testAddDomainWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/add/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"cl66666_x"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/domain_details.json", "application/json"))).build())).getDomainApi();
        Assert.assertEquals((Object)api.create("cl66666_x", new AddDomainOptions[0]), (Object)this.domainInDomainDetails());
    }

    public void testAddDomainWithOptsWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/add/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"cl66666_x"}).addFormParam("primarynameserver", new String[]{"ns1.somewhere.x"}).addFormParam("expire", new String[]{"1"}).addFormParam("minimum", new String[]{"1"}).addFormParam("refresh", new String[]{"1"}).addFormParam("responsibleperson", new String[]{"Tester."}).addFormParam("retry", new String[]{"1"}).addFormParam("ttl", new String[]{"1"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/domain_details.json", "application/json"))).build())).getDomainApi();
        AddDomainOptions options = (AddDomainOptions)AddDomainOptions.Builder.primaryNameServer((String)"ns1.somewhere.x").expire(1).minimum(1).refresh(1).responsiblePerson("Tester").retry(1).ttl(1);
        Assert.assertEquals((Object)api.create("cl66666_x", new AddDomainOptions[]{options}), (Object)this.domainInDomainDetails());
    }

    public void testUpdateDomainWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/edit/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"x"}).addFormParam("expire", new String[]{"1"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/domain_details.json", "application/json"))).build())).getDomainApi();
        Assert.assertEquals((Object)api.update("x", DomainOptions.Builder.expire((int)1)), (Object)this.domainInDomainDetails());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testUpdateDomainWhenResponseIs4xxThrows() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/edit/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"x"}).addFormParam("expire", new String[]{"1"}).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        api.update("x", DomainOptions.Builder.expire((int)1));
    }

    public void testDeleteDomainWhenResponseIs2xx() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/delete/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"x"}).build(), HttpResponse.builder().statusCode(200).build())).getDomainApi();
        api.delete("x");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testDeleteDomainWhenResponseIs4xxThrows() throws Exception {
        DomainApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/domain/delete/format/json").addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("domainname", new String[]{"x"}).build(), HttpResponse.builder().statusCode(404).build())).getDomainApi();
        api.delete("x");
    }
}

