/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.features;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.glesys.GleSYSApi;
import org.jclouds.glesys.domain.Cost;
import org.jclouds.glesys.domain.IpDetails;
import org.jclouds.glesys.features.IpApi;
import org.jclouds.glesys.internal.BaseGleSYSApiExpectTest;
import org.jclouds.glesys.options.ListIpOptions;
import org.jclouds.glesys.parse.ParseIpAddressFromResponseTest;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ResourceNotFoundException;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="IpApiExpectTest")
public class IpApiExpectTest
extends BaseGleSYSApiExpectTest {
    public void testListIpsWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/ip/listown/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/ip_list_own.json"))).build())).getIpApi();
        IpDetails.Builder builder = IpDetails.builder().datacenter("Falkenberg").version4().reserved(true).platform("OpenVZ").nameServers(new String[]{"79.99.4.100", "79.99.4.101"}).cost(Cost.builder().amount(2.0).currency("EUR").timePeriod("month").build());
        Assert.assertEquals((String)api.list(new ListIpOptions[0]).toString(), (String)ImmutableSet.of((Object)builder.ptr("31-192-230-68-static.serverhotell.net.").address("31.192.230.68").serverId(null).build(), (Object)builder.ptr("31-192-231-148-static.serverhotell.net.").address("31.192.231.148").serverId("vz1609110").build()).toString());
    }

    public void testListIpsWhenResponseIs4xxReturnsEmpty() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/ip/listown/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getIpApi();
        Assert.assertTrue((boolean)api.list(new ListIpOptions[0]).isEmpty());
    }

    public void testGetIpDetailsWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/ip/details/ipaddress/31.192.227.113/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/ip_get_details.json"))).build())).getIpApi();
        Assert.assertEquals((Object)api.get("31.192.227.113"), (Object)this.getIpInIpDetails());
    }

    protected IpDetails getIpInIpDetails() {
        return IpDetails.builder().datacenter("Falkenberg").version4().platform("OpenVZ").ptr("31-192-227-113-static.serverhotell.net.").nameServers(new String[]{"79.99.4.100", "79.99.4.101"}).address("31.192.227.113").cost(Cost.builder().amount(2.0).currency("EUR").timePeriod("month").build()).build();
    }

    public void testGetIpDetailsWhenResponseIs4xxReturnsNull() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/ip/details/ipaddress/31.192.227.37/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getIpApi();
        Assert.assertEquals((Object)api.get("31.192.227.37"), null);
    }

    public void testTakeWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/take/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"46.21.105.186"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/ip_take.json"))).build())).getIpApi();
        api.take("46.21.105.186");
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testTakeWhenResponseIs4xxThrowsResponseException() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/take/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"46.21.105.186"}).build(), HttpResponse.builder().statusCode(400).build())).getIpApi();
        api.take("46.21.105.186");
    }

    public void testReleaseWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/release/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"46.21.105.186"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/ip_release.json"))).build())).getIpApi();
        api.release("46.21.105.186");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testReleaseWhenResponseIs4xxThrowsResponseException() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/release/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"46.21.105.186"}).build(), HttpResponse.builder().statusCode(404).build())).getIpApi();
        api.release("46.21.105.186");
    }

    public void testListFreeWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/ip/listfree/ipversion/4/datacenter/Falkenberg/platform/OpenVZ/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/ip_list_free.json"))).build())).getIpApi();
        Assert.assertEquals((Set)api.listFree(4, "Falkenberg", "OpenVZ").toSet(), ParseIpAddressFromResponseTest.EXPECTED_IPS);
    }

    public void testListFreeWhenResponseIs404ReturnsEmptySet() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("https://api.glesys.com/ip/listfree/ipversion/6/datacenter/Falkenberg/platform/OpenVZ/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).build(), HttpResponse.builder().statusCode(404).build())).getIpApi();
        Assert.assertEquals((Set)api.listFree(6, "Falkenberg", "OpenVZ").toSet(), (Set)ImmutableSet.of());
    }

    public void testAddWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/add/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("serverid", new String[]{"vz1946889"}).build(), HttpResponse.builder().statusCode(200).build())).getIpApi();
        api.addToServer("31.192.227.37", "vz1946889");
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testAddWhenResponseIs4xxThrowsHttpException() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/add/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("serverid", new String[]{"vz1946889"}).build(), HttpResponse.builder().statusCode(401).build())).getIpApi();
        api.addToServer("31.192.227.37", "vz1946889");
    }

    public void testRemoveWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/remove/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("serverid", new String[]{"vz1946889"}).build(), HttpResponse.builder().statusCode(200).build())).getIpApi();
        api.removeFromServer("31.192.227.37", "vz1946889");
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testRemoveWhenResponseIs4xxThrowsHttpException() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/remove/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("serverid", new String[]{"vz1946889"}).build(), HttpResponse.builder().statusCode(400).build())).getIpApi();
        api.removeFromServer("31.192.227.37", "vz1946889");
    }

    public void testRemoveAndReleaseWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/remove/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("release", new String[]{"true"}).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("serverid", new String[]{"vz1946889"}).build(), HttpResponse.builder().statusCode(200).build())).getIpApi();
        api.removeFromServerAndRelease("31.192.227.37", "vz1946889");
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testRemoveAndReleaseWhenResponseIs4xxThrowsHttpException() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/remove/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("release", new String[]{"true"}).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("serverid", new String[]{"vz1946889"}).build(), HttpResponse.builder().statusCode(400).build())).getIpApi();
        api.removeFromServerAndRelease("31.192.227.37", "vz1946889");
    }

    public void testSetPrtWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/setptr/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("data", new String[]{"sommeptr."}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/ip_get_details.json", "application/json"))).build())).getIpApi();
        Assert.assertEquals((Object)api.setPtr("31.192.227.37", "sommeptr."), (Object)this.getIpInIpDetails());
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testSetPtrWhenResponseIs4xxThrowsHttpException() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/setptr/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).addFormParam("data", new String[]{"sommeptr."}).build(), HttpResponse.builder().statusCode(404).build())).getIpApi();
        api.setPtr("31.192.227.37", "sommeptr.");
    }

    public void testResetPrtWhenResponseIs2xx() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/resetptr/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/ip_get_details.json", "application/json"))).build())).getIpApi();
        Assert.assertEquals((Object)api.resetPtr("31.192.227.37"), (Object)this.getIpInIpDetails());
    }

    @Test(expectedExceptions={AuthorizationException.class})
    public void testResetPtrWhenResponseIs4xxThrowsHttpException() {
        IpApi api = ((GleSYSApi)this.requestSendsResponse(((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://api.glesys.com/ip/resetptr/format/json").addHeader("Accept", new String[]{"application/json"})).addHeader("Authorization", new String[]{"Basic aWRlbnRpdHk6Y3JlZGVudGlhbA=="})).addFormParam("ipaddress", new String[]{"31.192.227.37"}).build(), HttpResponse.builder().statusCode(401).build())).getIpApi();
        api.resetPtr("31.192.227.37");
    }
}

