/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.glesys.domain.Cost;

public class AllowedArguments {
    private final Cost costPerUnit;
    private final Set<Integer> allowedUnits;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromAllowedArgument(this);
    }

    @ConstructorProperties(value={"costperunit", "units"})
    protected AllowedArguments(Cost costPerUnit, Set<Integer> units) {
        this.costPerUnit = (Cost)Preconditions.checkNotNull((Object)costPerUnit, (Object)"costPerUnit");
        this.allowedUnits = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(units, (Object)"allowedUnits")));
    }

    public Cost getCostPerUnit() {
        return this.costPerUnit;
    }

    public Set<Integer> getAllowedUnits() {
        return this.allowedUnits;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.costPerUnit, this.allowedUnits});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllowedArguments that = (AllowedArguments)AllowedArguments.class.cast(obj);
        return Objects.equal((Object)this.costPerUnit, (Object)that.costPerUnit) && Objects.equal(this.allowedUnits, that.allowedUnits);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("costPerUnit", (Object)this.costPerUnit).add("allowedUnits", this.allowedUnits);
    }

    public String toString() {
        return this.string().toString();
    }

    public static class Builder {
        protected Cost costPerUnit;
        protected Set<Integer> allowedUnits;

        public Builder costPerUnit(Cost costPerUnit) {
            this.costPerUnit = costPerUnit;
            return this;
        }

        public Builder allowedUnits(Set<Integer> allowedUnits) {
            this.allowedUnits = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(allowedUnits, (Object)"allowedUnits")));
            return this;
        }

        public Builder allowedUnits(Integer ... allowedUnits) {
            return this.allowedUnits((Set<Integer>)ImmutableSet.copyOf((Object[])allowedUnits));
        }

        public AllowedArguments build() {
            return new AllowedArguments(this.costPerUnit, this.allowedUnits);
        }

        public Builder fromAllowedArgument(AllowedArguments in) {
            return this.costPerUnit(in.getCostPerUnit()).allowedUnits(in.getAllowedUnits());
        }
    }
}

