/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.glesys.domain.EmailOverviewDomain;
import org.jclouds.glesys.domain.EmailOverviewSummary;

@Beta
public class EmailOverview {
    private final EmailOverviewSummary summary;
    private final Set<EmailOverviewDomain> domains;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromEmailOverview(this);
    }

    @ConstructorProperties(value={"summary", "domains"})
    protected EmailOverview(EmailOverviewSummary summary, Set<EmailOverviewDomain> domains) {
        this.summary = (EmailOverviewSummary)Preconditions.checkNotNull((Object)summary, (Object)"summary");
        this.domains = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(domains, (Object)"domains")));
    }

    public EmailOverviewSummary getSummary() {
        return this.summary;
    }

    public Set<EmailOverviewDomain> gets() {
        return this.domains;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.summary, this.domains});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EmailOverview that = (EmailOverview)EmailOverview.class.cast(obj);
        return Objects.equal((Object)this.summary, (Object)that.summary) && Objects.equal(this.domains, that.domains);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((String)"").add("summary", (Object)this.summary).add("domains", this.domains);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected EmailOverviewSummary summary;
        protected Set<EmailOverviewDomain> domains = ImmutableSet.of();

        protected abstract T self();

        public T summary(EmailOverviewSummary summary) {
            this.summary = (EmailOverviewSummary)Preconditions.checkNotNull((Object)summary, (Object)"summary");
            return this.self();
        }

        public T domains(Set<EmailOverviewDomain> domains) {
            this.domains = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(domains, (Object)"domains")));
            return this.self();
        }

        public T domains(EmailOverviewDomain ... in) {
            return this.domains((Set<EmailOverviewDomain>)ImmutableSet.copyOf((Object[])in));
        }

        public EmailOverview build() {
            return new EmailOverview(this.summary, this.domains);
        }

        public T fromEmailOverview(EmailOverview in) {
            return ((Builder)this.summary(in.getSummary())).domains(in.gets());
        }
    }
}

