/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glesys.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.glesys.domain.Cost;
import org.jclouds.glesys.domain.Ip;
import org.jclouds.glesys.domain.Server;
import org.jclouds.javax.annotation.Nullable;

public class ServerDetails
extends Server {
    private final Server.State state;
    private final String description;
    private final String templateName;
    private final int cpuCores;
    private final int memorySizeMB;
    private final int diskSizeGB;
    private final int transferGB;
    private final Cost cost;
    private final Set<Ip> ips;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromServerDetails(this);
    }

    @ConstructorProperties(value={"serverid", "hostname", "datacenter", "platform", "state", "description", "templatename", "cpucores", "memorysize", "disksize", "transfer", "cost", "iplist"})
    protected ServerDetails(String id, String hostname, String datacenter, String platform, @Nullable Server.State state, @Nullable String description, String templateName, int cpuCores, int memorySizeMB, int diskSizeGB, int transferGB, Cost cost, @Nullable Set<Ip> ips) {
        super(id, hostname, datacenter, platform);
        this.state = state;
        this.description = description;
        this.templateName = (String)Preconditions.checkNotNull((Object)templateName, (Object)"templateName");
        this.cpuCores = cpuCores;
        this.memorySizeMB = memorySizeMB;
        this.diskSizeGB = diskSizeGB;
        this.transferGB = transferGB;
        this.cost = (Cost)Preconditions.checkNotNull((Object)cost, (Object)"cost");
        this.ips = ips == null ? ImmutableSet.of() : ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(ips, (Object)"ips")));
    }

    public Server.State getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public int getCpuCores() {
        return this.cpuCores;
    }

    public int getMemorySizeMB() {
        return this.memorySizeMB;
    }

    public int getDiskSizeGB() {
        return this.diskSizeGB;
    }

    public int getTransferGB() {
        return this.transferGB;
    }

    public Cost getCost() {
        return this.cost;
    }

    public Set<Ip> getIps() {
        return this.ips;
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("state", (Object)this.state).add("description", (Object)this.description).add("templateName", (Object)this.templateName).add("cpuCores", this.cpuCores).add("memorySizeMB", this.memorySizeMB).add("diskSizeGB", this.diskSizeGB).add("transferGB", this.transferGB).add("cost", (Object)this.cost).add("ips", this.ips);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Server.Builder<T> {
        protected Server.State state;
        protected String description;
        protected String templateName;
        protected int cpuCores;
        protected int memorySizeMB;
        protected int diskSizeGB;
        protected int transferGB;
        protected Cost cost;
        protected Set<Ip> ips = ImmutableSet.of();

        public T state(Server.State state) {
            this.state = (Server.State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state"));
            return (T)((Builder)this.self());
        }

        public T description(String description) {
            this.description = (String)Preconditions.checkNotNull((Object)description, (Object)"description");
            return (T)((Builder)this.self());
        }

        public T templateName(String templateName) {
            this.templateName = (String)Preconditions.checkNotNull((Object)templateName, (Object)"templateName");
            return (T)((Builder)this.self());
        }

        public T cpuCores(int cpuCores) {
            this.cpuCores = cpuCores;
            return (T)((Builder)this.self());
        }

        public T memorySizeMB(int memorySizeMB) {
            this.memorySizeMB = memorySizeMB;
            return (T)((Builder)this.self());
        }

        public T diskSizeGB(int diskSizeGB) {
            this.diskSizeGB = diskSizeGB;
            return (T)((Builder)this.self());
        }

        public T transferGB(int transferGB) {
            this.transferGB = transferGB;
            return (T)((Builder)this.self());
        }

        public T cost(Cost cost) {
            this.cost = (Cost)Preconditions.checkNotNull((Object)cost, (Object)"cost");
            return (T)((Builder)this.self());
        }

        public T ips(Set<Ip> ips) {
            this.ips = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(ips, (Object)"ips")));
            return (T)((Builder)this.self());
        }

        public T ips(Ip ... in) {
            return this.ips((Set<Ip>)ImmutableSet.copyOf((Object[])in));
        }

        @Override
        public ServerDetails build() {
            return new ServerDetails(this.id, this.hostname, this.datacenter, this.platform, this.state, this.description, this.templateName, this.cpuCores, this.memorySizeMB, this.diskSizeGB, this.transferGB, this.cost, this.ips);
        }

        public T fromServerDetails(ServerDetails in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromServer(in)).state(in.getState())).description(in.getDescription())).templateName(in.getTemplateName())).cpuCores(in.getCpuCores())).memorySizeMB(in.getMemorySizeMB())).diskSizeGB(in.getDiskSizeGB())).transferGB(in.getTransferGB())).cost(in.getCost())).ips(in.getIps());
        }
    }
}

