/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="GoGridTemplateBuilderLiveTest")
public class GoGridTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public GoGridTemplateBuilderLiveTest() {
        this.provider = "gogrid";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case RHEL: {
                        return input.version.equals("") || input.version.matches("5.[67]");
                    }
                    case DEBIAN: {
                        return input.version.equals("") || input.version.matches("[56].0");
                    }
                    case UBUNTU: {
                        return input.version.equals("") || input.version.equals("10.04");
                    }
                    case CENTOS: {
                        return input.version.equals("") || input.version.matches("5.[06]") || input.version.equals("6.0");
                    }
                    case WINDOWS: {
                        return input.version.equals("") || input.version.matches("200[38]");
                    }
                }
                return false;
            }
        });
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"10.04");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)0.5);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"US-CA", (Object)"US-VA", (Object)"NL-NH");
    }
}

