/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.util.Map;
import org.easymock.EasyMock;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.gogrid.compute.functions.ServerToNodeMetadata;
import org.jclouds.gogrid.compute.suppliers.GoGridHardwareSupplier;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.Option;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerState;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ServerToNodeMetadataTest")
public class ServerToNodeMetadataTest {
    GroupNamingConvention.Factory namingConvention = (GroupNamingConvention.Factory)Guice.createInjector((Module[])new Module[0]).getInstance(GroupNamingConvention.Factory.class);

    @Test
    public void testApplySetsTagFromNameAndCredentialsFromName() {
        Map serverStateToNodeStatus = (Map)EasyMock.createMock(Map.class);
        Image jcImage = (Image)EasyMock.createMock(Image.class);
        Option dc = Option.createWithIdNameAndDescription((Long)1L, (String)"US-West-1", (String)"US West 1 Datacenter");
        Option ram = Option.createWithIdNameAndDescription((Long)1L, (String)"512MB", (String)"Server with 512MB RAM");
        ImmutableSet images = ImmutableSet.of((Object)jcImage);
        Server server = (Server)EasyMock.createMock(Server.class);
        EasyMock.expect((Object)server.getId()).andReturn((Object)1000L).atLeastOnce();
        EasyMock.expect((Object)server.getName()).andReturn((Object)"group-ff").atLeastOnce();
        EasyMock.expect((Object)server.getState()).andReturn((Object)ServerState.ON).atLeastOnce();
        EasyMock.expect(serverStateToNodeStatus.get(ServerState.ON)).andReturn((Object)NodeMetadata.Status.RUNNING);
        Location location = new LocationBuilder().scope(LocationScope.ZONE).id("1").description("US-West-1").build();
        ImmutableSet locations = ImmutableSet.of((Object)location);
        EasyMock.expect((Object)server.getIp()).andReturn((Object)Ip.builder().ip("127.0.0.1").build());
        ServerImage image = (ServerImage)EasyMock.createMock(ServerImage.class);
        EasyMock.expect((Object)server.getImage()).andReturn((Object)image).atLeastOnce();
        EasyMock.expect((Object)server.getRam()).andReturn((Object)ram).atLeastOnce();
        EasyMock.expect((Object)server.getDatacenter()).andReturn((Object)dc).atLeastOnce();
        EasyMock.expect((Object)image.getId()).andReturn((Object)2000L).atLeastOnce();
        EasyMock.expect((Object)jcImage.getProviderId()).andReturn((Object)"2000").atLeastOnce();
        EasyMock.expect((Object)jcImage.getLocation()).andReturn((Object)location).atLeastOnce();
        EasyMock.expect((Object)jcImage.getOperatingSystem()).andReturn(EasyMock.createMock(OperatingSystem.class)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{serverStateToNodeStatus});
        EasyMock.replay((Object[])new Object[]{server});
        EasyMock.replay((Object[])new Object[]{image});
        EasyMock.replay((Object[])new Object[]{jcImage});
        ServerToNodeMetadata parser = new ServerToNodeMetadata(serverStateToNodeStatus, Suppliers.ofInstance((Object)images), Suppliers.ofInstance((Object)GoGridHardwareSupplier.H_ALL), Suppliers.ofInstance((Object)locations), this.namingConvention);
        NodeMetadata metadata = parser.apply(server);
        Assert.assertEquals((Object)metadata.getLocation(), (Object)location);
        Assert.assertEquals((String)metadata.getImageId(), (String)"2000");
        Assert.assertEquals((String)metadata.getGroup(), (String)"group");
        EasyMock.verify((Object[])new Object[]{serverStateToNodeStatus});
        EasyMock.verify((Object[])new Object[]{image});
        EasyMock.verify((Object[])new Object[]{server});
        EasyMock.verify((Object[])new Object[]{jcImage});
    }
}

