/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.handlers;

import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.gogrid.handlers.GoGridErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.json.config.GsonModule;
import org.testng.Assert;
import org.testng.TestException;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GoGridErrorHandlerTest")
public class GoGridErrorHandlerTest {
    @Test
    public void testHandler() {
        InputStream is = this.getClass().getResourceAsStream("/test_error_handler.json");
        GoGridErrorHandler handler = (GoGridErrorHandler)Guice.createInjector((Module[])new Module[]{new GsonModule()}).getInstance(GoGridErrorHandler.class);
        HttpCommand command = this.createHttpCommand();
        handler.handleError(command, ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("ok").payload(is)).build());
        Exception createdException = command.getException();
        Assert.assertNotNull((Object)createdException, (String)"There should've been an exception generated");
        String message = createdException.getMessage();
        Assert.assertTrue((boolean)message.contains("No object found that matches your input criteria."), (String)"Didn't find the expected error cause in the exception message");
        Assert.assertTrue((boolean)message.contains("IllegalArgumentException"), (String)"Didn't find the expected error code in the exception message");
        try {
            is.available();
            throw new TestException("Stream wasn't closed by the GoGridErrorHandler when it should've");
        }
        catch (IOException e) {
            return;
        }
    }

    HttpCommand createHttpCommand() {
        return new HttpCommand(HttpRequest.builder().method("GET").endpoint("http://localhost").build());
    }

    InputStream createInputStreamFromString(String s) {
        return new ByteArrayInputStream(s.getBytes());
    }
}

