/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.options;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.jclouds.gogrid.options.SaveImageOptions;
import org.jclouds.http.options.HttpRequestOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="SaveImageOptionsTest")
public class SaveImageOptionsTest {
    @Test
    public void testAssignability() {
        assert (HttpRequestOptions.class.isAssignableFrom(SaveImageOptions.class));
        assert (!String.class.isAssignableFrom(SaveImageOptions.class));
    }

    @Test
    public void testWithDescription() {
        SaveImageOptions options = new SaveImageOptions();
        options.withDescription("test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWith501LengthDescription() {
        SaveImageOptions options = new SaveImageOptions();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 501; ++i) {
            builder.append('a');
        }
        String description = builder.toString();
        options.withDescription(description);
    }

    @Test
    public void testWith500LengthDescription() {
        SaveImageOptions options = new SaveImageOptions();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 500; ++i) {
            builder.append('a');
        }
        String description = builder.toString();
        options.withDescription(description);
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of((Object)description));
    }

    @Test
    public void testNullWithDescription() {
        SaveImageOptions options = new SaveImageOptions();
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of());
    }

    @Test
    public void testWithDescriptionStatic() {
        SaveImageOptions options = SaveImageOptions.Builder.withDescription((String)"test");
        Assert.assertEquals((Collection)options.buildQueryParameters().get((Object)"description"), (Collection)ImmutableList.of((Object)"test"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testWithDescriptionNPE() {
        SaveImageOptions.Builder.withDescription(null);
    }
}

