/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.predicates;

import com.google.common.collect.ImmutableSet;
import org.easymock.EasyMock;
import org.jclouds.gogrid.domain.Job;
import org.jclouds.gogrid.domain.JobState;
import org.jclouds.gogrid.domain.Server;
import org.jclouds.gogrid.options.GetJobListOptions;
import org.jclouds.gogrid.predicates.ServerLatestJobCompleted;
import org.jclouds.gogrid.services.GridJobClient;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="ServerLatestJobCompletedTest")
public class ServerLatestJobCompletedTest {
    @Test
    public void testPredicate() {
        String serverName = "SERVER_NAME";
        Server server = (Server)EasyMock.createMock(Server.class);
        EasyMock.expect((Object)server.getName()).andStubReturn((Object)"SERVER_NAME");
        Job job = (Job)EasyMock.createMock(Job.class);
        EasyMock.expect((Object)job.getCurrentState()).andReturn((Object)JobState.SUCCEEDED);
        GridJobClient client = (GridJobClient)EasyMock.createMock(GridJobClient.class);
        EasyMock.expect((Object)client.getJobList(new GetJobListOptions[]{GetJobListOptions.Builder.latestJobForObjectByName((String)"SERVER_NAME")})).andReturn((Object)ImmutableSet.of((Object)job));
        EasyMock.replay((Object[])new Object[]{job});
        EasyMock.replay((Object[])new Object[]{client});
        EasyMock.replay((Object[])new Object[]{server});
        ServerLatestJobCompleted predicate = new ServerLatestJobCompleted(client);
        Assert.assertTrue((boolean)predicate.apply(server), (String)"The result of the predicate should've been 'true'");
    }
}

