/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.services;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.gogrid.domain.Ip;
import org.jclouds.gogrid.domain.IpPortPair;
import org.jclouds.gogrid.domain.LoadBalancerPersistenceType;
import org.jclouds.gogrid.domain.LoadBalancerType;
import org.jclouds.gogrid.functions.ParseLoadBalancerFromJsonResponse;
import org.jclouds.gogrid.functions.ParseLoadBalancerListFromJsonResponse;
import org.jclouds.gogrid.options.AddLoadBalancerOptions;
import org.jclouds.gogrid.services.BaseGoGridAsyncClientTest;
import org.jclouds.gogrid.services.GridLoadBalancerAsyncClient;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GridLoadBalancerAsyncClientTest")
public class GridLoadBalancerAsyncClientTest
extends BaseGoGridAsyncClientTest<GridLoadBalancerAsyncClient> {
    HttpRequest addLoadBalancer = HttpRequest.builder().method("GET").endpoint("https://api.gogrid.com/api/grid/loadbalancer/add").addQueryParam("v", new String[]{"1.5"}).addQueryParam("name", new String[]{"BalanceIt"}).addQueryParam("loadbalancer.type", new String[]{"Least Connect"}).addQueryParam("loadbalancer.persistence", new String[]{"SSL Sticky"}).addQueryParam("virtualip.ip", new String[]{"127.0.0.1"}).addQueryParam("virtualip.port", new String[]{"80"}).addQueryParam("realiplist.0.ip", new String[]{"127.0.0.1"}).addQueryParam("realiplist.0.port", new String[]{"8080"}).addQueryParam("realiplist.1.ip", new String[]{"127.0.0.1"}).addQueryParam("realiplist.1.port", new String[]{"9090"}).addQueryParam("sig", new String[]{"e9aafd0a5d4c69bb24536be4bce8a528"}).addQueryParam("api_key", new String[]{"identity"}).build();

    @Test
    public void testGetLoadBalancerList() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridLoadBalancerAsyncClient.class, (String)"getLoadBalancerList", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/list?v=1.5 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseLoadBalancerListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/list?v=1.5&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testAddLoadBalancer() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridLoadBalancerAsyncClient.class, (String)"addLoadBalancer", (Class[])new Class[]{String.class, IpPortPair.class, List.class, AddLoadBalancerOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"BalanceIt", (Object)IpPortPair.builder().ip(Ip.builder().ip("127.0.0.1").build()).port(80).build(), (Object)ImmutableList.of((Object)IpPortPair.builder().ip(Ip.builder().ip("127.0.0.1").build()).port(8080).build(), (Object)IpPortPair.builder().ip(Ip.builder().ip("127.0.0.1").build()).port(9090).build()), (Object)new AddLoadBalancerOptions.Builder().create(LoadBalancerType.LEAST_CONNECTED, LoadBalancerPersistenceType.SSL_STICKY)));
        request = (GeneratedHttpRequest)((HttpRequestFilter)request.getFilters().get(0)).filter((HttpRequest)request);
        this.assertRequestLineEquals((HttpRequest)request, this.addLoadBalancer.getRequestLine());
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    @Test
    public void testEditLoadBalancer() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridLoadBalancerAsyncClient.class, (String)"editLoadBalancer", (Class[])new Class[]{Long.TYPE, List.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)1L, (Object)ImmutableList.of((Object)IpPortPair.builder().ip(Ip.builder().ip("127.0.0.1").build()).port(8080).build(), (Object)IpPortPair.builder().ip(Ip.builder().ip("127.0.0.1").build()).port(9090).build())));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&id=1&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&id=1&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testEditLoadBalancerNamed() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridLoadBalancerAsyncClient.class, (String)"editLoadBalancerNamed", (Class[])new Class[]{String.class, List.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"BalanceIt", (Object)ImmutableList.of((Object)IpPortPair.builder().ip(Ip.builder().ip("127.0.0.1").build()).port(8080).build(), (Object)IpPortPair.builder().ip(Ip.builder().ip("127.0.0.1").build()).port(9090).build())));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&name=BalanceIt&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/edit?v=1.5&name=BalanceIt&realiplist.0.ip=127.0.0.1&realiplist.0.port=8080&realiplist.1.ip=127.0.0.1&realiplist.1.port=9090&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testGetLoadBalancersByName() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridLoadBalancerAsyncClient.class, (String)"getLoadBalancersByName", (Class[])new Class[]{String[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"My Load Balancer", (Object)"My Load Balancer 2"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/get?v=1.5&name=My%20Load%20Balancer&name=My%20Load%20Balancer%202 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseLoadBalancerListFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/get?v=1.5&name=My%20Load%20Balancer&name=My%20Load%20Balancer%202&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }

    @Test
    public void testDeleteLoadBalancerById() throws NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(GridLoadBalancerAsyncClient.class, (String)"deleteById", (Class[])new Class[]{Long.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)55L));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/delete?v=1.5&id=55 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ParseLoadBalancerFromJsonResponse.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.gogrid.com/api/grid/loadbalancer/delete?v=1.5&id=55&sig=e9aafd0a5d4c69bb24536be4bce8a528&api_key=identity HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
    }
}

