/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.compute;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.internal.BaseNovaApiExpectTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="HPCloudComputeProviderMetadataExpectTest")
public class HPCloudComputeProviderMetadataExpectTest
extends BaseNovaApiExpectTest {
    public HPCloudComputeProviderMetadataExpectTest() {
        this.provider = "hpcloud-compute";
        this.identity = "tenant:username";
        this.credential = "password";
    }

    public void testCanGetConfiguredZones() {
        HttpRequest authenticate = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/tokens").addHeader("Accept", new String[]{"application/json"})).payload(HPCloudComputeProviderMetadataExpectTest.payloadFromStringWithContentType((String)"{\"auth\":{\"passwordCredentials\":{\"username\":\"username\",\"password\":\"password\"},\"tenantName\":\"tenant\"}}", (String)"application/json"))).build();
        HttpResponse authenticationResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/access_hpcloud.json", "application/json"))).build();
        NovaApi whenNovaRegionExists = (NovaApi)this.requestSendsResponse(authenticate, authenticationResponse);
        Assert.assertEquals((Set)whenNovaRegionExists.getConfiguredZones(), (Set)ImmutableSet.of((Object)"az-3.region-a.geo-1", (Object)"az-2.region-a.geo-1", (Object)"az-1.region-a.geo-1"));
    }
}

