/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.compute;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.hpcloud.compute.config.HPCloudComputeServiceContextModule;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneAuthenticationModule;
import org.jclouds.openstack.keystone.v2_0.config.MappedAuthenticationApiModule;
import org.jclouds.openstack.nova.v2_0.NovaApiMetadata;
import org.jclouds.openstack.nova.v2_0.config.NovaParserModule;
import org.jclouds.openstack.nova.v2_0.config.NovaRestClientModule;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.providers.internal.BaseProviderMetadata;

public class HPCloudComputeProviderMetadata
extends BaseProviderMetadata {
    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return HPCloudComputeProviderMetadata.builder().fromProviderMetadata((ProviderMetadata)this);
    }

    public HPCloudComputeProviderMetadata() {
        super((BaseProviderMetadata.Builder)HPCloudComputeProviderMetadata.builder());
    }

    public HPCloudComputeProviderMetadata(Builder builder) {
        super((BaseProviderMetadata.Builder)builder);
    }

    public static Properties defaultProperties() {
        Properties properties = NovaApiMetadata.defaultProperties();
        properties.setProperty("jclouds.compute.timeout.node-terminated", "60000");
        properties.setProperty("jclouds.keystone.requires-tenant", "true");
        properties.setProperty("jclouds.openstack-nova.auto-create-floating-ips", "true");
        properties.setProperty("jclouds.openstack-nova.auto-generate-keypairs", "true");
        properties.setProperty("jclouds.template", "osFamily=UBUNTU,osVersionMatches=1[012].[01][04],os64Bit=true,locationId=az-2.region-a.geo-1");
        return properties;
    }

    public static class Builder
    extends BaseProviderMetadata.Builder {
        protected Builder() {
            this.id("hpcloud-compute").name("HP Cloud Compute Services").apiMetadata((ApiMetadata)((NovaApiMetadata.Builder)((NovaApiMetadata.Builder)((NovaApiMetadata.Builder)new NovaApiMetadata().toBuilder().endpointName("identity service url ending in /v2.0/")).defaultEndpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/")).defaultModules((Set)ImmutableSet.builder().add(MappedAuthenticationApiModule.class).add(KeystoneAuthenticationModule.class).add(KeystoneAuthenticationModule.ZoneModule.class).add(NovaParserModule.class).add(NovaRestClientModule.class).add(HPCloudComputeServiceContextModule.class).build())).build()).homepage(URI.create("http://hpcloud.com")).console(URI.create("https://manage.hpcloud.com/compute")).linkedServices(new String[]{"hpcloud-compute", "hpcloud-objectstorage"}).iso3166Codes(new String[]{"US-NV"}).endpoint("https://region-a.geo-1.identity.hpcloudsvc.com:35357/v2.0/").defaultProperties(HPCloudComputeProviderMetadata.defaultProperties());
        }

        public HPCloudComputeProviderMetadata build() {
            return new HPCloudComputeProviderMetadata(this);
        }

        public Builder fromProviderMetadata(ProviderMetadata in) {
            super.fromProviderMetadata(in);
            return this;
        }
    }
}

