/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage;

import com.google.common.collect.ImmutableSet;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.RecordedRequest;
import java.util.Set;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;
import org.jclouds.hpcloud.objectstorage.internal.BaseHPCloudObjectStorageMockTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
public class HPCloudObjectStorageApiMockTest
extends BaseHPCloudObjectStorageMockTest {
    String mixedSwiftVersions = "{\"access\": {\n  \"token\": {\n    \"expires\": \"2013-10-01T09:16:20.177Z\",\n    \"id\": \"HPAuth10_1234567890\",\n    \"tenant\": {\n      \"id\": \"12345678\",\n      \"name\": \"jclouds-project\"\n    }\n  },\n  \"user\": {\n    \"id\": \"12345678\",\n    \"name\": \"jclouds\"\n  },\n  \"serviceCatalog\": [\n    {\n      \"name\": \"Object Storage\",\n      \"type\": \"object-store\",\n      \"endpoints\": [\n        {\n          \"tenantId\": \"12345678\",\n          \"publicURL\": \"URL\\/v1\\/12345678\",\n          \"region\": \"region-a.geo-1\",\n          \"versionId\": \"1.0\",\n          \"versionInfo\": \"URL\\/v1.0\\/\",\n          \"versionList\": \"URL\"\n        },\n        {\n          \"tenantId\": \"12345678\",\n          \"publicURL\": \"URL\\/v1\\/12345678\",\n          \"region\": \"region-b.geo-1\",\n          \"versionId\": \"1\",\n          \"versionInfo\": \"URL\\/v1\\/\",\n          \"versionList\": \"URL\"\n      }]\n    }\n  ]\n}}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mixedVersionsInRegions() throws Exception {
        MockWebServer server = HPCloudObjectStorageApiMockTest.mockWebServer();
        server.enqueue(new MockResponse().setBody(this.mixedSwiftVersions));
        try {
            HPCloudObjectStorageApi api = HPCloudObjectStorageApiMockTest.api(server.getUrl("/").toString());
            Assert.assertEquals((Set)api.getConfiguredRegions(), (Set)ImmutableSet.of((Object)"region-a.geo-1", (Object)"region-b.geo-1"));
            Assert.assertEquals((int)server.getRequestCount(), (int)1);
            RecordedRequest authRequest = server.takeRequest();
            Assert.assertEquals((String)authRequest.getRequestLine(), (String)"POST /tokens HTTP/1.1");
        }
        finally {
            server.shutdown();
        }
    }
}

