/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.internal;

import com.google.common.base.Function;
import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageProviderMetadata;
import org.jclouds.hpcloud.objectstorage.internal.KeystoneFixture;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.internal.BaseRestClientExpectTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="HPCloudObjectStorageExpectTest")
public class BaseHPCloudObjectStorageBlobStoreExpectTest
extends BaseRestClientExpectTest<BlobStore> {
    protected HttpRequest keystoneAuthWithUsernameAndPassword;
    protected HttpRequest keystoneAuthWithAccessKeyAndSecretKey;
    protected String authToken;
    protected HttpResponse responseWithKeystoneAccess;

    public BaseHPCloudObjectStorageBlobStoreExpectTest() {
        this.provider = "hpcloud-objectstorage";
        this.keystoneAuthWithUsernameAndPassword = KeystoneFixture.INSTANCE.initialAuthWithUsernameAndPassword(this.identity, this.credential);
        this.keystoneAuthWithAccessKeyAndSecretKey = KeystoneFixture.INSTANCE.initialAuthWithAccessKeyAndSecretKey(this.identity, this.credential);
        this.authToken = KeystoneFixture.INSTANCE.getAuthToken();
        this.responseWithKeystoneAccess = KeystoneFixture.INSTANCE.responseWithAccess();
        this.identity = KeystoneFixture.INSTANCE.getTenantName() + ":" + this.identity;
    }

    public BlobStore createClient(Function<HttpRequest, HttpResponse> fn, Module module, Properties props) {
        return (BlobStore)this.createInjector(fn, module, props).getInstance(BlobStore.class);
    }

    public ProviderMetadata createProviderMetadata() {
        return new HPCloudObjectStorageProviderMetadata();
    }
}

