/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.hpcloud.objectstorage.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.mockwebserver.Dispatcher;
import com.google.mockwebserver.MockResponse;
import com.google.mockwebserver.MockWebServer;
import com.google.mockwebserver.QueueDispatcher;
import com.google.mockwebserver.RecordedRequest;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.jclouds.ContextBuilder;
import org.jclouds.concurrent.config.ExecutorServiceModule;
import org.jclouds.hpcloud.objectstorage.HPCloudObjectStorageApi;

public class BaseHPCloudObjectStorageMockTest {
    public static HPCloudObjectStorageApi api(String uri) {
        Properties overrides = new Properties();
        overrides.setProperty("jclouds.max-retries", "1");
        return (HPCloudObjectStorageApi)ContextBuilder.newBuilder((String)"hpcloud-objectstorage").credentials("jclouds:joe", "letmein").endpoint(uri).overrides(overrides).modules((Iterable)ImmutableSet.of((Object)new ExecutorServiceModule(MoreExecutors.sameThreadExecutor(), MoreExecutors.sameThreadExecutor()))).buildApi(HPCloudObjectStorageApi.class);
    }

    public static MockWebServer mockWebServer() throws IOException {
        MockWebServer server = new MockWebServer();
        server.play();
        URL url = server.getUrl("");
        server.setDispatcher((Dispatcher)BaseHPCloudObjectStorageMockTest.getURLReplacingQueueDispatcher(url));
        return server;
    }

    public static QueueDispatcher getURLReplacingQueueDispatcher(final URL url) {
        QueueDispatcher dispatcher = new QueueDispatcher(){
            protected final BlockingQueue<MockResponse> responseQueue = new LinkedBlockingQueue<MockResponse>();

            public MockResponse dispatch(RecordedRequest request) throws InterruptedException {
                MockResponse response = this.responseQueue.take();
                if (response.getBody() != null) {
                    String newBody = new String(response.getBody()).replace(":\"URL", ":\"" + url.toString());
                    response = response.setBody(newBody);
                }
                return response;
            }

            public void enqueueResponse(MockResponse response) {
                this.responseQueue.add(response);
            }
        };
        return dispatcher;
    }
}

