/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ninefold.compute.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class NinefoldComputeTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public NinefoldComputeTemplateBuilderLiveTest() {
        this.provider = "ninefold-compute";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case UBUNTU: {
                        return input.version.equals("") || input.version.equals("10.04");
                    }
                    case SUSE: {
                        return (input.version.equals("") || input.version.equals("11")) && input.is64Bit;
                    }
                    case DEBIAN: {
                        return (input.version.equals("") || input.version.equals("6.0")) && !input.is64Bit;
                    }
                    case CENTOS: {
                        return (input.version.equals("") || input.version.equals("5.5")) && input.is64Bit;
                    }
                    case WINDOWS: {
                        return input.version.equals("") || input.version.equals("2008") && !input.is64Bit;
                    }
                }
                return false;
            }
        });
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        if (this.template == null) {
            assert (defaultTemplate.getImage().getOperatingSystem().getVersion().matches("1[012].[10][04]")) : defaultTemplate.getImage().getOperatingSystem().getVersion();
            Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
            Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
            Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"1");
            Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
            Assert.assertEquals((String)defaultTemplate.getOptions().getLoginUser(), (String)"user");
            Assert.assertEquals((String)defaultTemplate.getOptions().getLoginPassword(), (String)"Password01");
            Assert.assertEquals((String)defaultTemplate.getOptions().getLoginPrivateKey(), null);
            Assert.assertEquals((Object)defaultTemplate.getOptions().shouldAuthenticateSudo(), (Object)Boolean.TRUE);
        } else {
            Assert.assertEquals((Object)defaultTemplate.getImage(), (Object)((ComputeServiceContext)this.view).getComputeService().templateBuilder().from(this.template).build().getImage());
        }
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"AU-NSW");
    }
}

