/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.cloudservers.uk.compute;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="CloudServersUKTemplateBuilderLiveTest")
public class CloudServersUKTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    public CloudServersUKTemplateBuilderLiveTest() {
        this.provider = "rackspace-cloudservers-uk";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return Predicates.not((Predicate)new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case UBUNTU: {
                        return (input.version.equals("") || input.version.matches("^1[012].*") && !input.version.equals("10.10")) && input.is64Bit;
                    }
                    case DEBIAN: {
                        return input.is64Bit && !input.version.equals("5.0");
                    }
                    case CENTOS: {
                        return (input.version.equals("") || input.version.equals("5.6") || input.version.equals("6.0")) && input.is64Bit;
                    }
                    case WINDOWS: {
                        return input.is64Bit && input.version.equals("");
                    }
                }
                return false;
            }
        });
    }

    @Test
    public void testTemplateBuilder() {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"12.04");
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((String)defaultTemplate.getImage().getName(), (String)"Ubuntu 12.04 LTS (Precise Pangolin)");
        Assert.assertEquals((String)defaultTemplate.getImage().getDefaultCredentials().getUser(), (String)"root");
        Assert.assertEquals((String)defaultTemplate.getLocation().getId(), (String)"LON");
        Assert.assertEquals((String)defaultTemplate.getImage().getLocation().getId(), (String)"LON");
        Assert.assertEquals((String)defaultTemplate.getHardware().getLocation().getId(), (String)"LON");
        Assert.assertEquals((boolean)((NovaTemplateOptions)defaultTemplate.getOptions().as(NovaTemplateOptions.class)).shouldAutoAssignFloatingIp(), (boolean)false);
        Assert.assertNull((Object)((NovaTemplateOptions)defaultTemplate.getOptions().as(NovaTemplateOptions.class)).getDiskConfig());
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"GB-SLG");
    }
}

