/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.trmk.ecloud.TerremarkECloudProviderMetadata;
import org.jclouds.trmk.ecloud.config.TerremarkECloudRestClientModule;
import org.jclouds.trmk.ecloud.domain.internal.ECloudOrgImpl;
import org.jclouds.trmk.vcloud_0_8.config.TerremarkVCloudRestClientModule;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.domain.internal.CatalogImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.CatalogItemImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.VDCImpl;
import org.jclouds.trmk.vcloud_0_8.endpoints.Network;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.TasksList;
import org.jclouds.trmk.vcloud_0_8.filters.SetVCloudTokenCookie;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudLoginClient;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudVersionsClient;
import org.testng.Assert;

public abstract class BaseTerremarkECloudAsyncClientTest<T>
extends BaseAsyncClientTest<T> {
    protected static final ReferenceTypeImpl ORG_REF = new ReferenceTypeImpl("org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1"));
    protected static final ReferenceTypeImpl CATALOG_REF = new ReferenceTypeImpl("catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1"));
    protected static final ReferenceTypeImpl TASKSLIST_REF = new ReferenceTypeImpl("tasksList", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/tasksList/1"));
    protected static final ReferenceTypeImpl VDC_REF = new ReferenceTypeImpl("vdc", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"));
    protected static final ReferenceTypeImpl KEYSLIST_REF = new ReferenceTypeImpl("keysList", "application/vnd.tmrk.ecloud.keysList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/keysList/1"));
    protected static final ReferenceTypeImpl TAGSLIST_REF = new ReferenceTypeImpl("deviceTags", "application/vnd.tmrk.ecloud.tagsList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/deviceTags/1"));
    protected static final ReferenceTypeImpl VAPPCATALOGLIST_REF = new ReferenceTypeImpl("vappCatalog", "application/vnd.tmrk.ecloud.VAppCatalogList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vappCatalog/1"));
    protected static final ReferenceTypeImpl DATACENTERSLIST_REF = new ReferenceTypeImpl("dataCentersList", "application/vnd.tmrk.ecloud.dataCentersList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/datacentersList/1"));
    protected static final ReferenceTypeImpl NETWORK_REF = new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.network+xml", URI.create("https://vcloud.safesecureweb.com/network/1990"));
    protected static final ReferenceTypeImpl PUBLICIPS_REF = new ReferenceTypeImpl("publicIps", "application/vnd.tmrk.vCloud.publicIpsList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/publicIps/1"));
    protected static final ReferenceTypeImpl INTERNETSERVICES_REF = new ReferenceTypeImpl("internetServices", "application/vnd.tmrk.ecloud.internetServicesList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/internetServices/1"));
    protected static final org.jclouds.trmk.vcloud_0_8.domain.Org ORG = new ECloudOrgImpl(ORG_REF.getName(), ORG_REF.getType(), ORG_REF.getHref(), "org", (Map)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)CATALOG_REF), (Map)ImmutableMap.of((Object)VDC_REF.getName(), (Object)VDC_REF), (Map)ImmutableMap.of((Object)TASKSLIST_REF.getName(), (Object)TASKSLIST_REF), (ReferenceType)KEYSLIST_REF, (ReferenceType)DATACENTERSLIST_REF, (ReferenceType)TAGSLIST_REF, (ReferenceType)VAPPCATALOGLIST_REF);
    protected static final VDC VDC = new VDCImpl(VDC_REF.getName(), VDC_REF.getType(), VDC_REF.getHref(), "description", (ReferenceType)CATALOG_REF, (ReferenceType)PUBLICIPS_REF, (ReferenceType)INTERNETSERVICES_REF, (Map)ImmutableMap.of((Object)"vapp", (Object)new ReferenceTypeImpl("vapp", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/188849-1")), (Object)"network", (Object)new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdcItem/2"))), (Map)ImmutableMap.of((Object)NETWORK_REF.getName(), (Object)NETWORK_REF));

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SetVCloudTokenCookie.class);
    }

    protected Module createModule() {
        return new TerremarkECloudRestClientModuleExtension();
    }

    public ProviderMetadata createProviderMetadata() {
        return new TerremarkECloudProviderMetadata();
    }

    @ConfiguresRestClient
    protected static class TerremarkECloudRestClientModuleExtension
    extends TerremarkECloudRestClientModule {
        protected TerremarkECloudRestClientModuleExtension() {
        }

        protected Supplier<URI> provideAuthenticationURI(TerremarkVCloudVersionsClient versionService, String version) {
            return Suppliers.ofInstance((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/login"));
        }

        protected Supplier<org.jclouds.trmk.vcloud_0_8.domain.Org> provideOrg(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, @Org Supplier<ReferenceType> defaultOrg) {
            return Suppliers.ofInstance((Object)ORG);
        }

        protected void installDefaultVCloudEndpointsModule() {
            this.install((Module)new AbstractModule(){

                protected void configure() {
                    TypeLiteral<Supplier<ReferenceType>> refTypeSupplier = new TypeLiteral<Supplier<ReferenceType>>(){};
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(Org.class).toInstance((Object)Suppliers.ofInstance((Object)ORG_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(org.jclouds.trmk.vcloud_0_8.endpoints.Catalog.class).toInstance((Object)Suppliers.ofInstance((Object)CATALOG_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(TasksList.class).toInstance((Object)Suppliers.ofInstance((Object)TASKSLIST_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(org.jclouds.trmk.vcloud_0_8.endpoints.VDC.class).toInstance((Object)Suppliers.ofInstance((Object)VDC_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(Network.class).toInstance((Object)Suppliers.ofInstance((Object)NETWORK_REF));
                }
            });
        }

        protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, TerremarkVCloudLoginClient login) {
            return Suppliers.ofInstance((Object)new VCloudSession(){

                public Map<String, ReferenceType> getOrgs() {
                    return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ORG_REF);
                }

                public String getVCloudToken() {
                    return "token";
                }
            });
        }

        protected void configure() {
            super.configure();
            this.bind(TerremarkVCloudRestClientModule.OrgMapSupplier.class).to(TestOrgMapSupplier.class);
            this.bind(TerremarkVCloudRestClientModule.OrgCatalogSupplier.class).to(TestOrgCatalogSupplier.class);
            this.bind(TerremarkVCloudRestClientModule.OrgCatalogItemSupplier.class).to(TestOrgCatalogItemSupplier.class);
        }

        protected Supplier<Map<String, Map<String, ? extends VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, TerremarkVCloudRestClientModule.OrgVDCSupplier supplier) {
            return Suppliers.ofInstance((Object)ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)VDC.getName(), (Object)VDC)));
        }

        @Singleton
        public static class TestOrgCatalogItemSupplier
        extends TerremarkVCloudRestClientModule.OrgCatalogItemSupplier {
            protected TestOrgCatalogItemSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, Map<String, ? extends CatalogItem>>> get() {
                return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)ImmutableMap.of((Object)"template", (Object)new CatalogItemImpl("template", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2"), "description", (ReferenceType)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2")), null, null, (Map)ImmutableMap.of()))));
            }
        }

        @Singleton
        public static class TestOrgCatalogSupplier
        extends TerremarkVCloudRestClientModule.OrgCatalogSupplier {
            @Inject
            protected TestOrgCatalogSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, ? extends Catalog>> get() {
                return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)new CatalogImpl(CATALOG_REF.getName(), CATALOG_REF.getType(), CATALOG_REF.getHref(), null, (Map)ImmutableMap.of((Object)"item", (Object)new ReferenceTypeImpl("item", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/1")), (Object)"template", (Object)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2"))))));
            }
        }

        @Singleton
        public static class TestOrgMapSupplier
        extends TerremarkVCloudRestClientModule.OrgMapSupplier {
            @Inject
            protected TestOrgMapSupplier() {
                super(null, null);
            }

            public Map<String, org.jclouds.trmk.vcloud_0_8.domain.Org> get() {
                return ImmutableMap.of((Object)ORG.getName(), (Object)ORG);
            }
        }
    }
}

