/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.compute;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import java.util.Properties;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.ComputeType;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.jclouds.trmk.ecloud.TerremarkECloudClient;
import org.jclouds.trmk.vcloud_0_8.domain.VApp;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true)
public class TerremarkECloudComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.setProperty("jclouds.vcloud.defaults.vdc", ".* - " + System.getProperty("test.trmk-ecloud.datacenter", "MIA"));
        return props;
    }

    public TerremarkECloudComputeServiceLiveTest() {
        this.provider = "trmk-ecloud";
    }

    public void setServiceDefaults() {
        this.group = "te";
    }

    protected void checkUserMetadataContains(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        assert (node.getUserMetadata().equals(ImmutableMap.of())) : String.format("node userMetadata did not match %s %s", userMetadata, node);
    }

    protected Template buildTemplate(TemplateBuilder templateBuilder) {
        Template template = super.buildTemplate(templateBuilder);
        Image image = template.getImage();
        assert (image.getDefaultCredentials() != null && image.getDefaultCredentials().identity != null) : image;
        assert (image.getDefaultCredentials() != null && image.getDefaultCredentials().credential != null) : image;
        return template;
    }

    public void testListImages() throws Exception {
        for (Image image : this.client.listImages()) {
            assert (image.getProviderId() != null) : image;
            Assert.assertEquals((Object)image.getType(), (Object)ComputeType.IMAGE);
            if (image.getOperatingSystem().getFamily() == OsFamily.WINDOWS || image.getOperatingSystem().getFamily() == OsFamily.SOLARIS) continue;
            assert (image.getDefaultCredentials() != null && image.getDefaultCredentials().identity != null) : image;
            assert (image.getDefaultCredentials().credential != null) : image;
        }
    }

    public void testListNodes() throws Exception {
        for (ComputeMetadata node : this.client.listNodes()) {
            assert (node.getProviderId() != null);
            assert (node.getLocation() != null);
            Assert.assertEquals((Object)node.getType(), (Object)ComputeType.NODE);
            NodeMetadata allData = this.client.getNodeMetadata(node.getId());
            TerremarkECloudClient api = (TerremarkECloudClient)((ComputeServiceContext)this.view).utils().injector().getInstance(TerremarkECloudClient.class);
            VApp vApp = api.findVAppInOrgVDCNamed(allData.getLocation().getParent().getDescription(), allData.getLocation().getDescription(), allData.getName());
            Assert.assertEquals((String)vApp.getName(), (String)allData.getName());
        }
    }

    public void testDestroyNodes() {
        super.testDestroyNodes();
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }
}

