/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.compute;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.domain.OsFamilyVersion64Bit;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.internal.BaseTemplateBuilderLiveTest;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TerremarkECloudTemplateBuilderLiveTest")
public class TerremarkECloudTemplateBuilderLiveTest
extends BaseTemplateBuilderLiveTest {
    protected Properties setupProperties() {
        Properties props = super.setupProperties();
        props.setProperty("jclouds.vcloud.defaults.vdc", ".* - " + System.getProperty("test.trmk-ecloud.datacenter", "MIA"));
        return props;
    }

    public TerremarkECloudTemplateBuilderLiveTest() {
        this.provider = "trmk-ecloud";
    }

    protected Predicate<OsFamilyVersion64Bit> defineUnsupportedOperatingSystems() {
        return new Predicate<OsFamilyVersion64Bit>(){

            public boolean apply(OsFamilyVersion64Bit input) {
                switch (input.family) {
                    case RHEL: {
                        return !input.version.equals("") && !input.version.matches("5.[50]");
                    }
                    case SOLARIS: {
                        return !input.is64Bit;
                    }
                    case CENTOS: {
                        return !input.version.equals("") && !input.version.matches("5.[50]");
                    }
                    case UBUNTU: {
                        return !input.version.equals("") && !input.version.equals("10.04") && !input.version.equals("8.04");
                    }
                    case WINDOWS: {
                        return !(input.version.equals("") || input.version.equals("2003 R2") || input.version.equals("2008") && !input.is64Bit || input.version.matches("2008( R2)?") && input.is64Bit);
                    }
                }
                return true;
            }
        };
    }

    @Test
    public void testDefaultTemplateBuilder() throws IOException {
        Template defaultTemplate = ((ComputeServiceContext)this.view).getComputeService().templateBuilder().build();
        Assert.assertEquals((String)defaultTemplate.getImage().getOperatingSystem().getVersion(), (String)"10.04");
        Assert.assertEquals((boolean)defaultTemplate.getImage().getOperatingSystem().is64Bit(), (boolean)true);
        Assert.assertEquals((Object)defaultTemplate.getImage().getOperatingSystem().getFamily(), (Object)OsFamily.UBUNTU);
        Assert.assertEquals((Object)ComputeServiceUtils.getCores((Hardware)defaultTemplate.getHardware()), (Object)1.0);
    }

    protected Set<String> getIso3166Codes() {
        return ImmutableSet.of((Object)"US-FL", (Object)"US-VA", (Object)"NL-NH", (Object)"BR-SP");
    }
}

