/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.ecloud.BaseTerremarkECloudAsyncClientTest;
import org.jclouds.trmk.ecloud.features.DataCenterOperationsAsyncClient;
import org.jclouds.trmk.vcloud_0_8.xml.DataCentersHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DataCenterOperationsAsyncClientTest")
public class DataCenterOperationsAsyncClientTest
extends BaseTerremarkECloudAsyncClientTest<DataCenterOperationsAsyncClient> {
    public void testlistDataCenters() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(DataCenterOperationsAsyncClient.class, (String)"listDataCenters", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/dataCenters")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://services.enterprisecloud.terremark.com/api/v0.8b-ext2.8/extensions/org/1910324/dataCenters HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.dataCentersList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DataCentersHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testlistDataCentersInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(DataCenterOperationsAsyncClient.class, (String)"listDataCentersInOrg", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/datacentersList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.ecloud.dataCentersList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, DataCentersHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }
}

