/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.ecloud.xml;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.trmk.ecloud.TerremarkECloudApiMetadata;
import org.jclouds.trmk.ecloud.xml.TagNameToUsageCountHandler;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TagNameToUsageCountHandlerTest")
public class TagNameToUsageCountHandlerTest
extends BaseHandlerTest {
    @BeforeTest
    protected void setUpInjector() {
        this.injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule(){

            public void configure() {
                super.configure();
                Names.bindProperties((Binder)this.binder(), (Properties)TerremarkECloudApiMetadata.defaultProperties());
            }
        }});
        this.factory = (ParseSax.Factory)this.injector.getInstance(ParseSax.Factory.class);
        assert (this.factory != null);
    }

    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/deviceTags.xml");
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(TagNameToUsageCountHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)ImmutableMap.of((Object)"Tag1", (Object)1, (Object)"Tag2", (Object)5, (Object)"Tag3", (Object)12));
    }
}

