/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.trmk.vcloudexpress;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.Invokable;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresRestClient;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.trmk.vcloud_0_8.config.TerremarkVCloudRestClientModule;
import org.jclouds.trmk.vcloud_0_8.domain.Catalog;
import org.jclouds.trmk.vcloud_0_8.domain.CatalogItem;
import org.jclouds.trmk.vcloud_0_8.domain.Protocol;
import org.jclouds.trmk.vcloud_0_8.domain.ReferenceType;
import org.jclouds.trmk.vcloud_0_8.domain.VCloudSession;
import org.jclouds.trmk.vcloud_0_8.domain.VDC;
import org.jclouds.trmk.vcloud_0_8.domain.internal.CatalogImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.CatalogItemImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.OrgImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.ReferenceTypeImpl;
import org.jclouds.trmk.vcloud_0_8.domain.internal.VDCImpl;
import org.jclouds.trmk.vcloud_0_8.endpoints.Network;
import org.jclouds.trmk.vcloud_0_8.endpoints.Org;
import org.jclouds.trmk.vcloud_0_8.endpoints.TasksList;
import org.jclouds.trmk.vcloud_0_8.filters.SetVCloudTokenCookie;
import org.jclouds.trmk.vcloud_0_8.functions.ParseTaskFromLocationHeader;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudLoginClient;
import org.jclouds.trmk.vcloud_0_8.internal.TerremarkVCloudVersionsClient;
import org.jclouds.trmk.vcloud_0_8.options.AddInternetServiceOptions;
import org.jclouds.trmk.vcloud_0_8.options.AddNodeOptions;
import org.jclouds.trmk.vcloud_0_8.options.InstantiateVAppTemplateOptions;
import org.jclouds.trmk.vcloud_0_8.xml.CatalogHandler;
import org.jclouds.trmk.vcloud_0_8.xml.CatalogItemHandler;
import org.jclouds.trmk.vcloud_0_8.xml.CustomizationParametersHandler;
import org.jclouds.trmk.vcloud_0_8.xml.InternetServiceHandler;
import org.jclouds.trmk.vcloud_0_8.xml.InternetServicesHandler;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairByNameHandler;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairHandler;
import org.jclouds.trmk.vcloud_0_8.xml.KeyPairsHandler;
import org.jclouds.trmk.vcloud_0_8.xml.NodeHandler;
import org.jclouds.trmk.vcloud_0_8.xml.NodesHandler;
import org.jclouds.trmk.vcloud_0_8.xml.VAppHandler;
import org.jclouds.trmk.vcloud_0_8.xml.VDCHandler;
import org.jclouds.trmk.vcloudexpress.TerremarkVCloudExpressAsyncClient;
import org.jclouds.trmk.vcloudexpress.TerremarkVCloudExpressProviderMetadata;
import org.jclouds.trmk.vcloudexpress.config.TerremarkVCloudExpressRestClientModule;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="TerremarkVCloudExpressAsyncClientTest")
public class TerremarkVCloudExpressAsyncClientTest
extends BaseAsyncClientTest<TerremarkVCloudExpressAsyncClient> {
    protected static final ReferenceTypeImpl ORG_REF = new ReferenceTypeImpl("org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1"));
    protected static final ReferenceTypeImpl CATALOG_REF = new ReferenceTypeImpl("catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalog/1"));
    protected static final ReferenceTypeImpl TASKSLIST_REF = new ReferenceTypeImpl("tasksList", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/tasksList/1"));
    protected static final ReferenceTypeImpl VDC_REF = new ReferenceTypeImpl("vdc", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"));
    protected static final ReferenceTypeImpl KEYSLIST_REF = new ReferenceTypeImpl("keysList", "application/vnd.tmrk.vcloudExpress.keysList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/keysList/1"));
    protected static final ReferenceTypeImpl NETWORK_REF = new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.network+xml", URI.create("https://vcloud.safesecureweb.com/network/1990"));
    protected static final ReferenceTypeImpl PUBLICIPS_REF = new ReferenceTypeImpl("publicIps", "application/vnd.tmrk.vCloud.publicIpsList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/publicIps/1"));
    protected static final ReferenceTypeImpl INTERNETSERVICES_REF = new ReferenceTypeImpl("internetServices", "application/vnd.tmrk.vCloud.internetServicesList+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/internetServices/1"));
    protected static final org.jclouds.trmk.vcloud_0_8.domain.Org ORG = new OrgImpl(ORG_REF.getName(), ORG_REF.getType(), ORG_REF.getHref(), "org", (Map)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)CATALOG_REF), (Map)ImmutableMap.of((Object)VDC_REF.getName(), (Object)VDC_REF), (Map)ImmutableMap.of((Object)TASKSLIST_REF.getName(), (Object)TASKSLIST_REF), (ReferenceType)KEYSLIST_REF);
    protected static final VDC VDC = new VDCImpl(VDC_REF.getName(), VDC_REF.getType(), VDC_REF.getHref(), "description", (ReferenceType)CATALOG_REF, (ReferenceType)PUBLICIPS_REF, (ReferenceType)INTERNETSERVICES_REF, (Map)ImmutableMap.of((Object)"vapp", (Object)new ReferenceTypeImpl("vapp", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/188849-1")), (Object)"network", (Object)new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdcItem/2"))), (Map)ImmutableMap.of((Object)NETWORK_REF.getName(), (Object)NETWORK_REF));

    public void testListOrgs() {
        Assert.assertEquals((String)((TerremarkVCloudExpressAsyncClient)this.injector.getInstance(TerremarkVCloudExpressAsyncClient.class)).listOrgs().toString(), (String)ImmutableMap.of((Object)ORG_REF.getName(), (Object)ORG_REF).toString());
    }

    public void testCatalogItemURI() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getCatalogItem", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogItemHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDelete() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"deleteVApp", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud.safesecureweb.com/api/v0.8/vApp/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseTaskFromLocationHeader.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindCatalogItemInOrgCatalogNamed() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"findCatalogItemInOrgCatalogNamed", (Class[])new Class[]{String.class, String.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"org", (Object)"catalog", (Object)"item"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/catalogItem/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalogItem+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogItemHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testCatalog() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getCatalog", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://catalog")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://catalog HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.catalog+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CatalogHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetVDC() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getVDC", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/vdc/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/vdc/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vdc+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VDCHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testInstantiateVAppTemplateInVDCURI() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"instantiateVAppTemplateInVDC", (Class[])new Class[]{URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), (Object)URI.create("https://vcloud/vAppTemplate/3"), (Object)"name"));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/InstantiateVAppTemplateParams-test.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testInstantiateVAppTemplateInVDCURIOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"instantiateVAppTemplateInVDC", (Class[])new Class[]{URI.class, URI.class, String.class, InstantiateVAppTemplateOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), (Object)URI.create("https://vcloud/vAppTemplate/3"), (Object)"name", (Object)InstantiateVAppTemplateOptions.Builder.processorCount((int)2).memory(512L).inGroup("group").withPassword("password").inRow("row").addNetworkConfig(new InstantiateVAppTemplateOptions.NetworkConfig(URI.create("http://network")))));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/vdc/1/action/instantiateVAppTemplate HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vApp+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/InstantiateVAppTemplateParams-options-test.xml")), "application/vnd.vmware.vcloud.instantiateVAppTemplateParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VAppHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"addInternetServiceToVDC", (Class[])new Class[]{URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), (Object)"name", (Object)Protocol.TCP, (Object)22));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/internetServices/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService-test2.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"addInternetServiceToVDC", (Class[])new Class[]{URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1"), (Object)"name", (Object)Protocol.TCP, (Object)22, (Object)AddInternetServiceOptions.Builder.disabled().withDescription("yahoo")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud.safesecureweb.com/api/v0.8/internetServices/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService-options-test.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetAllInternetServices() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getAllInternetServicesInVDC", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/internetServices/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetServicesList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServicesHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getInternetService", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/internetService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetServicesList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteInternetService() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"deleteInternetService", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/internetService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceToExistingIp() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"addInternetServiceToExistingIp", (Class[])new Class[]{URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/publicIp/12"), (Object)"name", (Object)Protocol.TCP, (Object)22));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/publicIp/12/internetServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService-test2.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddInternetServiceToExistingIpOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"addInternetServiceToExistingIp", (Class[])new Class[]{URI.class, String.class, Protocol.class, Integer.TYPE, AddInternetServiceOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/publicIp/12"), (Object)"name", (Object)Protocol.TCP, (Object)22, (Object)AddInternetServiceOptions.Builder.disabled().withDescription("yahoo")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/publicIp/12/internetServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.internetService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateInternetService-options-test.xml")), "application/vnd.tmrk.vCloud.internetService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, InternetServiceHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddNode() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"addNode", (Class[])new Class[]{URI.class, String.class, String.class, Integer.TYPE, AddNodeOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12"), (Object)"10.2.2.2", (Object)"name", (Object)22));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateNodeService-test2.xml")), "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testAddNodeOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"addNode", (Class[])new Class[]{URI.class, String.class, String.class, Integer.TYPE, AddNodeOptions[].class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12"), (Object)"10.2.2.2", (Object)"name", (Object)22, (Object)AddNodeOptions.Builder.disabled().withDescription("yahoo")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/CreateNodeService-options-test.xml")), "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetKeyPairInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"findKeyPairInOrg", (Class[])new Class[]{URI.class, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1"), (Object)"keyPair"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vcloudExpress.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairByNameHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfigureNodeWithDescription() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"configureNode", (Class[])new Class[]{URI.class, String.class, Boolean.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/nodeService/12"), (Object)"name", (Object)true, (Object)"eggs"));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>name</Name><Enabled>true</Enabled><Description>eggs</Description></NodeService>", "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testConfigureNodeNoDescription() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"configureNode", (Class[])new Class[]{URI.class, String.class, Boolean.TYPE, String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{URI.create("https://vcloud/extensions/nodeService/12"), "name", true, null}));
        this.assertRequestLineEquals((HttpRequest)request, "PUT https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<NodeService xmlns=\"urn:tmrk:vCloudExpressExtensions-1.6\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><Name>name</Name><Enabled>true</Enabled></NodeService>", "application/vnd.tmrk.vCloud.nodeService+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetNodes() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getNodes", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/internetService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/internetService/12/nodeServices HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodesHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteNode() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"deleteNode", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/nodeService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetCustomizationOptionsOfCatalogItem() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getCustomizationOptions", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/template/12/options/customization")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/template/12/options/customization HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.catalogItemCustomizationParameters+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, CustomizationParametersHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testListKeyPairsInOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"listKeyPairsInOrg", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/org/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vcloudExpress.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairsHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testListKeyPairsInOrgNull() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"listKeyPairsInOrg", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)Lists.newArrayList((Object[])new Object[]{null}));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud.safesecureweb.com/api/v0.8/keysList/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vcloudExpress.keysList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairsHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.EmptySetOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    @Test(expectedExceptions={ResourceNotFoundException.class})
    public void testListKeyPairsInOrgNotFound() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"listKeyPairsInOrg", (Class[])new Class[]{URI.class});
        this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("d")));
    }

    public void testGetNode() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getNode", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/nodeService/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/nodeService/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.tmrk.vCloud.nodeService+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, NodeHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetKeyPair() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"getKeyPair", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/key/12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcloud/extensions/key/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, KeyPairHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeleteKeyPair() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(TerremarkVCloudExpressAsyncClient.class, (String)"deleteKeyPair", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcloud/extensions/key/12")));
        this.assertRequestLineEquals((HttpRequest)request, "DELETE https://vcloud/extensions/key/12 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), SetVCloudTokenCookie.class);
    }

    protected Module createModule() {
        return new TerremarkVCloudRestClientModuleExtension();
    }

    public ProviderMetadata createProviderMetadata() {
        return new TerremarkVCloudExpressProviderMetadata();
    }

    @ConfiguresRestClient
    protected static class TerremarkVCloudRestClientModuleExtension
    extends TerremarkVCloudExpressRestClientModule {
        protected TerremarkVCloudRestClientModuleExtension() {
        }

        protected Supplier<URI> provideAuthenticationURI(TerremarkVCloudVersionsClient versionService, String version) {
            return Suppliers.ofInstance((Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/login"));
        }

        protected Supplier<org.jclouds.trmk.vcloud_0_8.domain.Org> provideOrg(Supplier<Map<String, ? extends org.jclouds.trmk.vcloud_0_8.domain.Org>> orgSupplier, @Org Supplier<ReferenceType> defaultOrg) {
            return Suppliers.ofInstance((Object)ORG);
        }

        protected void installDefaultVCloudEndpointsModule() {
            this.install((Module)new AbstractModule(){

                protected void configure() {
                    TypeLiteral<Supplier<ReferenceType>> refTypeSupplier = new TypeLiteral<Supplier<ReferenceType>>(){};
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(Org.class).toInstance((Object)Suppliers.ofInstance((Object)ORG_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(org.jclouds.trmk.vcloud_0_8.endpoints.Catalog.class).toInstance((Object)Suppliers.ofInstance((Object)CATALOG_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(TasksList.class).toInstance((Object)Suppliers.ofInstance((Object)TASKSLIST_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(org.jclouds.trmk.vcloud_0_8.endpoints.VDC.class).toInstance((Object)Suppliers.ofInstance((Object)VDC_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(Network.class).toInstance((Object)Suppliers.ofInstance((Object)NETWORK_REF));
                }
            });
        }

        protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, TerremarkVCloudLoginClient login) {
            return Suppliers.ofInstance((Object)new VCloudSession(){

                public Map<String, ReferenceType> getOrgs() {
                    return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ORG_REF);
                }

                public String getVCloudToken() {
                    return "token";
                }
            });
        }

        protected void configure() {
            super.configure();
            this.bind(TerremarkVCloudRestClientModule.OrgMapSupplier.class).to(TestOrgMapSupplier.class);
            this.bind(TerremarkVCloudRestClientModule.OrgCatalogSupplier.class).to(TestOrgCatalogSupplier.class);
            this.bind(TerremarkVCloudRestClientModule.OrgCatalogItemSupplier.class).to(TestOrgCatalogItemSupplier.class);
        }

        protected Supplier<Map<String, Map<String, ? extends VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, TerremarkVCloudRestClientModule.OrgVDCSupplier supplier) {
            return Suppliers.ofInstance((Object)ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)VDC.getName(), (Object)VDC)));
        }

        @Singleton
        public static class TestOrgCatalogItemSupplier
        extends TerremarkVCloudRestClientModule.OrgCatalogItemSupplier {
            protected TestOrgCatalogItemSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, Map<String, ? extends CatalogItem>>> get() {
                return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)ImmutableMap.of((Object)"template", (Object)new CatalogItemImpl("template", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2"), "description", (ReferenceType)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2")), null, null, (Map)ImmutableMap.of()))));
            }
        }

        @Singleton
        public static class TestOrgCatalogSupplier
        extends TerremarkVCloudRestClientModule.OrgCatalogSupplier {
            @Inject
            protected TestOrgCatalogSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, ? extends Catalog>> get() {
                return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)new CatalogImpl(CATALOG_REF.getName(), CATALOG_REF.getType(), CATALOG_REF.getHref(), null, (Map)ImmutableMap.of((Object)"item", (Object)new ReferenceTypeImpl("item", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/1")), (Object)"template", (Object)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/catalogItem/2"))))));
            }
        }

        @Singleton
        public static class TestOrgMapSupplier
        extends TerremarkVCloudRestClientModule.OrgMapSupplier {
            @Inject
            protected TestOrgMapSupplier() {
                super(null, null);
            }

            public Map<String, org.jclouds.trmk.vcloud_0_8.domain.Org> get() {
                return ImmutableMap.of((Object)ORG.getName(), (Object)ORG);
            }
        }
    }
}

