/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetAccountsListOfUserResponseTest;
import org.jclouds.ultradns.ws.parse.GetAvailableRegionsResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="UltraDNSWSApiExpectTest")
public class UltraDNSWSApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest getCurrentAccount = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/get_current_account.xml", "application/xml"))).build();
    HttpResponse getCurrentAccountResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/account.xml", "application/xml"))).build();
    HttpRequest getRegionsById = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_regions.xml", "application/xml"))).build();
    HttpResponse getRegionsByIdResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResourceWithContentType("/regions.xml", "application/xml"))).build();

    public void testGetCurrentAccountWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.getCurrentAccount, this.getCurrentAccountResponse);
        Assert.assertEquals((String)success.getCurrentAccount().toString(), (String)new GetAccountsListOfUserResponseTest().expected().toString());
    }

    public void testGetRegionsByIdWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.getRegionsById, this.getRegionsByIdResponse);
        Assert.assertEquals((String)success.getRegionsByIdAndName().toString(), (String)new GetAvailableRegionsResponseTest().expected().toString());
    }
}

