/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws;

import java.util.Collection;
import java.util.Map;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="UltraDNSWSApiLiveTest")
public class UltraDNSWSApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    @Test
    protected void testGetCurrentAccount() {
        IdAndName account = ((UltraDNSWSApi)this.api).getCurrentAccount();
        this.checkAccount(account);
    }

    private void checkAccount(IdAndName account) {
        Assert.assertNotNull((Object)account.getId(), (String)("Id cannot be null for " + account));
        Assert.assertNotNull((Object)account.getName(), (String)("Name cannot be null for " + account));
    }

    @Test
    public void testListRegions() {
        for (Map.Entry<IdAndName, Collection<String>> entry : ((UltraDNSWSApi)this.api).getRegionsByIdAndName().asMap().entrySet()) {
            this.checkRegion(entry);
        }
    }

    private void checkRegion(Map.Entry<IdAndName, Collection<String>> region) {
        Assert.assertNotNull((Object)region.getKey().getId(), (String)("Id cannot be null " + region));
        Assert.assertNotNull((Object)region.getKey().getName(), (String)("Name cannot be null " + region));
        Assert.assertNotNull(region.getValue(), (String)("TerritoryNames cannot be null " + region));
        Assert.assertFalse((boolean)region.getValue().isEmpty(), (String)("TerritoryNames cannot be empty " + region));
    }
}

