/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.features.DirectionalGroupApi;
import org.jclouds.ultradns.ws.features.DirectionalPoolApi;
import org.jclouds.ultradns.ws.internal.BaseDirectionalApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="DirectionalPoolApiLiveTest")
public class DirectionalPoolApiLiveTest
extends BaseDirectionalApiLiveTest {
    Set<IdAndName> allDirectionalGroups = Sets.newLinkedHashSet();

    @Test
    public void testListDirectionalPools() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            for (DirectionalPool pool : this.api(zone.getName()).list()) {
                this.checkDirectional(pool);
            }
        }
    }

    private void checkDirectional(DirectionalPool pool) {
        Assert.assertNotNull((Object)pool.getZoneId(), (String)("ZoneId cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getId(), (String)("Id cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getDName(), (String)("DName cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getName(), (String)("Name cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getType(), (String)("Type cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getTieBreak(), (String)("TieBreak cannot be null " + pool));
    }

    @Test
    public void testListDirectionalRecords() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            for (DirectionalPool pool : this.api(zone.getName()).list()) {
                for (DirectionalPool.RecordType type : EnumSet.allOf(DirectionalPool.RecordType.class)) {
                    for (DirectionalPoolRecordDetail rr : this.api(zone.getName()).listRecordsByDNameAndType(pool.getDName(), type.getCode())) {
                        DirectionalPoolApiLiveTest.checkDirectionalRecordDetail(rr);
                        Iterable groups = Optional.presentInstances((Iterable)ImmutableSet.of((Object)rr.getGroup(), (Object)rr.getGeolocationGroup(), (Object)rr.getGeolocationGroup()));
                        Assert.assertFalse((boolean)Iterables.isEmpty((Iterable)groups), (String)("No groups " + rr));
                        for (IdAndName group : groups) {
                            this.allDirectionalGroups.add(group);
                            Assert.assertNotNull((Object)group.getId(), (String)("Id cannot be null " + group));
                            Assert.assertNotNull((Object)group.getName(), (String)("Name cannot be null " + group));
                        }
                        Assert.assertEquals((String)rr.getZoneName(), (String)zone.getName());
                        Assert.assertEquals((String)rr.getName(), (String)pool.getDName());
                        switch (pool.getType()) {
                            case GEOLOCATION: {
                                Assert.assertNotNull((Object)rr.getGeolocationGroup().or(rr.getGroup()).orNull(), (String)("GeolocationGroup or Group must be present " + rr));
                                Assert.assertNull((Object)rr.getSourceIpGroup().orNull(), (String)("SourceIpGroup must be absent " + rr));
                                break;
                            }
                            case SOURCEIP: {
                                Assert.assertNotNull((Object)rr.getSourceIpGroup().orNull(), (String)("SourceIpGroup must be present " + rr));
                                Assert.assertNull((Object)rr.getGeolocationGroup().orNull(), (String)("GeolocationGroup must be absent " + rr));
                                break;
                            }
                            case MIXED: {
                                Assert.assertNotNull((Object)rr.getGeolocationGroup().or(rr.getSourceIpGroup()).or(rr.getGroup()).orNull(), (String)("GeolocationGroup, SourceIpGroup or Group must be present " + rr));
                            }
                        }
                    }
                }
            }
        }
    }

    static void checkDirectionalRecord(DirectionalPoolRecord rr) {
        Assert.assertNotNull((Object)rr.getType(), (String)("Type cannot be null " + rr));
        Assert.assertNotNull((Object)rr.getTTL(), (String)("TTL cannot be null " + rr));
        Assert.assertNotNull((Object)rr.getRData(), (String)("InfoValues cannot be null " + rr));
    }

    static DirectionalPoolRecordDetail checkDirectionalRecordDetail(DirectionalPoolRecordDetail rr) {
        Assert.assertNotNull((Object)rr.getZoneName(), (String)("ZoneName cannot be null " + rr));
        Assert.assertNotNull((Object)rr.getName(), (String)("DName cannot be null " + rr));
        Assert.assertNotNull((Object)rr.getId(), (String)("Id cannot be null " + rr));
        Assert.assertNotNull((Object)rr.getZoneName(), (String)("ZoneName cannot be null " + rr));
        DirectionalPoolApiLiveTest.checkDirectionalRecord(rr.getRecord());
        return rr;
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Parent Zone does not exist in the system.")
    public void testListDirectionalsWhenZoneIdNotFound() {
        this.api("AAAAAAAAAAAAAAAA").list();
    }

    @Test
    public void testDeleteWhenNotFound() {
        this.api(this.zoneName).delete("06063D9C54C5AE09");
    }

    @Test
    public void testDeleteRecordWhenNotFound() {
        this.api(this.zoneName).deleteRecord("06063D9C54C5AE09");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Directional Pool Record does not exist in the system")
    public void testUpdateRecordWhenNotFound() {
        this.api(this.zoneName).updateRecord("06063D9C54C5AE09", this.cnameRecordCanary);
    }

    @Test
    public void testCreateCNAMEPool() {
        this.cnamePoolId = this.api(this.zoneName).createForDNameAndType("Geo pool", this.dname, DirectionalPool.RecordType.IPV4.getCode());
        Logger.getAnonymousLogger().info("created Geo pool: " + this.cnamePoolId);
        Optional<DirectionalPool> ipv4Pool = this.getPoolById(this.cnamePoolId);
        Assert.assertTrue((boolean)ipv4Pool.isPresent());
        Assert.assertEquals((String)((DirectionalPool)ipv4Pool.get()).getZoneId(), (String)this.zoneId);
        Assert.assertEquals((String)((String)((DirectionalPool)ipv4Pool.get()).getName().get()), (String)"Geo pool");
        Assert.assertEquals((String)((DirectionalPool)ipv4Pool.get()).getDName(), (String)this.dname);
        Assert.assertEquals((Object)((DirectionalPool)ipv4Pool.get()).getType(), (Object)DirectionalPool.Type.GEOLOCATION);
        Assert.assertEquals((Object)((DirectionalPool)ipv4Pool.get()).getTieBreak(), (Object)DirectionalPool.TieBreak.GEOLOCATION);
    }

    @Test(dependsOnMethods={"testCreateCNAMEPool"}, expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class})
    public void testDuplicateCreateCNAMEPool() {
        this.api(this.zoneName).createForDNameAndType("Geo pool", this.dname, DirectionalPool.RecordType.IPV4.getCode());
    }

    @Test(dependsOnMethods={"testDuplicateCreateCNAMEPool"})
    public void addCNAMERecordsToPool() {
        this.cnameEU = this.api(this.zoneName).addRecordIntoNewGroup(this.cnamePoolId, this.cnameRecordEU, this.eu);
        Logger.getAnonymousLogger().info("created CNAME record in ipv4 pool: " + this.cnameEU);
        this.checkRecordConsistent(this.dname, this.cnameEU, this.cnameRecordEU, this.eu);
        this.cnameUS = this.api(this.zoneName).addRecordIntoNewGroup(this.cnamePoolId, this.cnameRecordUS, this.us);
        Logger.getAnonymousLogger().info("created CNAME record in ipv4 pool: " + this.cnameUS);
        this.checkRecordConsistent(this.dname, this.cnameUS, this.cnameRecordUS, this.us);
        this.cnameCanary = this.api(this.zoneName).addRecordIntoNewGroup(this.cnamePoolId, this.cnameRecordCanary, this.nebraska);
        Logger.getAnonymousLogger().info("created CNAME record in ipv4 pool: " + this.cnameCanary);
        this.checkRecordConsistent(this.dname, this.cnameCanary, this.cnameRecordCanary, this.nebraska);
    }

    @Test(dependsOnMethods={"addCNAMERecordsToPool"}, expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class})
    public void testDuplicateAddCNAMERecordsToPool() {
        this.api(this.zoneName).addRecordIntoNewGroup(this.cnamePoolId, this.cnameRecordEU, this.eu);
    }

    @Test(dependsOnMethods={"testDuplicateAddCNAMERecordsToPool"})
    public void testUpdateRecordTTL() {
        this.cnameRecordCanary = this.cnameRecordCanary.toBuilder().ttl(180).build();
        this.api(this.zoneName).updateRecord(this.cnameCanary, this.cnameRecordCanary);
        Logger.getAnonymousLogger().info("updated CNAME record TTL in ipv4 pool: " + this.cnameCanary);
        this.checkRecordConsistent(this.dname, this.cnameCanary, this.cnameRecordCanary, this.nebraska);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(dependsOnMethods={"testUpdateRecordTTL"}, expectedExceptions={UltraDNSWSExceptions.DirectionalGroupOverlapException.class})
    public void testUpdateGroupWithOverlappingTerritories() {
        DirectionalGroup withUtah = this.nebraska.toBuilder().mapRegionToTerritory("United States (US)", "Utah").build();
        this.checkGroupByDNameAndIdContainsTerritory(this.dname, this.cnameUS, "Utah");
        try {
            this.api(this.zoneName).updateRecordAndGroup(this.cnameCanary, this.cnameRecordCanary, withUtah);
        }
        finally {
            this.checkRecordConsistent(this.dname, this.cnameCanary, this.cnameRecordCanary, this.nebraska);
        }
    }

    @Test(dependsOnMethods={"testUpdateGroupWithOverlappingTerritories"})
    public void testUpdateGroupWithLessTerritories() {
        ImmutableMultimap minusUtah = ImmutableMultimap.builder().putAll((Object)"United States (US)", Iterables.filter((Iterable)this.us.get((Object)"United States (US)"), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"Utah")))).build();
        this.api(this.zoneName).updateRecordAndGroup(this.cnameUS, this.cnameRecordUS, this.us.toBuilder().regionToTerritories((Multimap)minusUtah).build());
        this.checkGroupByDNameAndIdDoesntContainTerritory(this.dname, this.cnameUS, "Utah");
    }

    @Test(dependsOnMethods={"testUpdateGroupWithLessTerritories"})
    public void testUpdateGroupWithMoreTerritories() {
        DirectionalGroup withUtah = this.nebraska.toBuilder().mapRegionToTerritory("United States (US)", "Utah").build();
        this.api(this.zoneName).updateRecordAndGroup(this.cnameCanary, this.cnameRecordCanary, withUtah);
        Logger.getAnonymousLogger().info("update CNAME record in ipv4 pool: " + this.cnameCanary);
        this.checkRecordConsistent(this.dname, this.cnameCanary, this.cnameRecordCanary, withUtah);
        this.checkGroupByDNameAndIdContainsTerritory(this.dname, this.cnameCanary, "Nebraska");
        this.checkGroupByDNameAndIdContainsTerritory(this.dname, this.cnameCanary, "Utah");
    }

    @Test(dependsOnMethods={"testUpdateGroupWithMoreTerritories"})
    public void testAddRecordIntoGeoGroup() {
        String geoGroupId = ((IdAndName)((DirectionalPoolRecordDetail)this.getRecordByDNameAndId(this.dname, this.cnameCanary).get()).getGeolocationGroup().get()).getId();
        this.cname2Canary = this.api(this.zoneName).addRecordIntoExistingGroup(this.cnamePoolId, this.cname2RecordCanary, geoGroupId);
        Logger.getAnonymousLogger().info("created CNAME record in ipv4 pool: " + this.cname2Canary);
        DirectionalPoolRecordDetail detail = this.checkRecordConsistentInNonConfiguredGroup(this.dname, this.cname2Canary, this.cname2RecordCanary);
        Assert.assertEquals((String)((IdAndName)detail.getGroup().get()).getId(), (String)geoGroupId);
    }

    @Test(dependsOnMethods={"testAddRecordIntoGeoGroup"})
    public void testDeleteRecord() {
        this.api(this.zoneName).deleteRecord(this.cnameEU);
        Assert.assertFalse((boolean)this.getRecordByDNameAndId(this.dname, this.cnameEU).isPresent());
        Assert.assertTrue((boolean)this.getRecordByDNameAndId(this.dname, this.cnameUS).isPresent());
    }

    @Test
    public void addRecordsWithUnconfiguredGroupToPool() {
        this.aPoolId = this.api(this.zoneName).createForDNameAndType("Geo pool", "a-" + this.dname, DirectionalPool.RecordType.IPV4.getCode());
        Logger.getAnonymousLogger().info("created Geo pool: " + this.aPoolId);
        this.a1Prod = this.api(this.zoneName).addFirstRecordInNonConfiguredGroup(this.aPoolId, this.a1RecordProd);
        Logger.getAnonymousLogger().info("created A record in ipv4 pool: " + this.a1Prod);
        this.checkRecordConsistentInNonConfiguredGroup("a-" + this.dname, this.a1Prod, this.a1RecordProd);
        this.checkGroupByDNameAndIdContainsTerritory("a-" + this.dname, this.a1Prod, "Nebraska");
        this.a1Canary = this.api(this.zoneName).addRecordIntoNewGroup(this.aPoolId, this.a1RecordCanary, this.nebraska);
        Logger.getAnonymousLogger().info("created A record in ipv4 pool: " + this.a1Canary);
        this.checkRecordConsistent("a-" + this.dname, this.a1Canary, this.a1RecordCanary, this.nebraska);
        this.checkGroupByDNameAndIdContainsTerritory("a-" + this.dname, this.a1Canary, "Nebraska");
        this.checkGroupByDNameAndIdDoesntContainTerritory("a-" + this.dname, this.a1Prod, "Nebraska");
    }

    @Test(dependsOnMethods={"addRecordsWithUnconfiguredGroupToPool"}, expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class})
    public void addDuplicateFirstRecordInNonConfiguredGroup() {
        this.api(this.zoneName).addFirstRecordInNonConfiguredGroup(this.aPoolId, this.a1RecordProd);
    }

    @Test(dependsOnMethods={"addRecordsWithUnconfiguredGroupToPool"}, expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class})
    public void addDuplicateRecordIntoNewGroup() {
        this.api(this.zoneName).addRecordIntoNewGroup(this.aPoolId, this.a1RecordCanary, this.nebraska);
    }

    @Test(dependsOnMethods={"addDuplicateFirstRecordInNonConfiguredGroup", "addRecordsWithUnconfiguredGroupToPool"})
    public void testRemovingAddsTerritoriesBackIntoNonConfiguredGroup() {
        this.api(this.zoneName).deleteRecord(this.a1Canary);
        Assert.assertFalse((boolean)this.getRecordByDNameAndId("a-" + this.dname, this.a1Canary).isPresent());
        this.checkGroupByDNameAndIdContainsTerritory("a-" + this.dname, this.a1Prod, "Nebraska");
    }

    @Test(dependsOnMethods={"testDeleteRecord", "testRemovingAddsTerritoriesBackIntoNonConfiguredGroup"})
    public void testDeletePool() {
        this.api(this.zoneName).delete(this.cnamePoolId);
        Assert.assertFalse((boolean)this.getPoolById(this.cnamePoolId).isPresent());
        this.api(this.zoneName).delete(this.aPoolId);
        Assert.assertFalse((boolean)this.getPoolById(this.aPoolId).isPresent());
    }

    private DirectionalPoolRecordDetail checkRecordConsistent(String dname, String recordId, DirectionalPoolRecord record, DirectionalGroup group) {
        DirectionalPoolRecordDetail recordDetail = (DirectionalPoolRecordDetail)this.getRecordByDNameAndId(dname, recordId).get();
        DirectionalPoolApiLiveTest.checkDirectionalRecordDetail(recordDetail);
        IdAndName rGroup = (IdAndName)recordDetail.getGeolocationGroup().get();
        Assert.assertEquals((String)rGroup.getName(), (String)group.getName());
        if (!group.containsValue((Object)"all")) {
            Assert.assertEquals((Object)this.groupApi().get(rGroup.getId()), (Object)group);
        }
        Assert.assertFalse((boolean)recordDetail.getGroup().isPresent());
        Assert.assertFalse((boolean)recordDetail.getSourceIpGroup().isPresent());
        Assert.assertEquals((String)recordDetail.getName(), (String)dname);
        Assert.assertEquals((String)recordDetail.getZoneName(), (String)this.zoneName);
        Assert.assertEquals((Object)recordDetail.getRecord(), (Object)record);
        return recordDetail;
    }

    private DirectionalPoolRecordDetail checkRecordConsistentInNonConfiguredGroup(String dname, String recordId, DirectionalPoolRecord record) {
        DirectionalPoolRecordDetail recordDetail = (DirectionalPoolRecordDetail)this.getRecordByDNameAndId(dname, recordId).get();
        DirectionalPoolApiLiveTest.checkDirectionalRecordDetail(recordDetail);
        IdAndName rGroup = (IdAndName)recordDetail.getGroup().get();
        Assert.assertEquals((String)rGroup.getName(), (String)"All Non-Configured Regions");
        DirectionalGroup allNonConfigured = this.groupApi().get(rGroup.getId());
        Assert.assertEquals((String)allNonConfigured.getName(), (String)"All Non-Configured Regions");
        Assert.assertEquals((int)allNonConfigured.size(), (int)323);
        Assert.assertFalse((boolean)recordDetail.getGeolocationGroup().isPresent());
        Assert.assertFalse((boolean)recordDetail.getSourceIpGroup().isPresent());
        Assert.assertEquals((String)recordDetail.getZoneName(), (String)this.zoneName);
        Assert.assertEquals((Object)recordDetail.getRecord(), (Object)record);
        return recordDetail;
    }

    private DirectionalPoolApi api(String zoneName) {
        return ((UltraDNSWSApi)this.api).getDirectionalPoolApiForZone(zoneName);
    }

    private DirectionalGroupApi groupApi() {
        return ((UltraDNSWSApi)this.api).getDirectionalGroupApiForAccount(this.account.getId());
    }
}

