/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.ResourceRecord;
import org.jclouds.ultradns.ws.domain.ResourceRecordDetail;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.features.ResourceRecordApi;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="ResourceRecordApiLiveTest")
public class ResourceRecordApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    AtomicLong zones = new AtomicLong();
    LoadingCache<Integer, AtomicLong> recordTypeCounts = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Integer, AtomicLong>(){

        public AtomicLong load(Integer key) throws Exception {
            return new AtomicLong();
        }
    });
    String guid;
    ResourceRecord mx = ResourceRecord.rrBuilder().name("mail." + this.zoneName).type(15).ttl(1800).infoValue((Object)10).infoValue((Object)"maileast.jclouds.org.").build();
    static Function<ResourceRecordDetail, ResourceRecord> toRecord = new Function<ResourceRecordDetail, ResourceRecord>(){

        public ResourceRecord apply(ResourceRecordDetail in) {
            ResourceRecordApiLiveTest.checkResourceRecordMetadata(in);
            return in.getRecord();
        }
    };

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.createZone();
    }

    static void checkResourceRecord(ResourceRecord rr) {
        Assert.assertNotNull((Object)rr.getName(), (String)("DName cannot be null for " + rr));
        Assert.assertNotNull((Object)rr.getType(), (String)("Type cannot be null for " + rr));
        Assert.assertTrue((rr.getType() > 0 ? 1 : 0) != 0, (String)("Type must be unsigned for " + rr));
        Assert.assertNotNull((Object)rr.getType(), (String)("Type cannot be null for " + rr));
        Assert.assertNotNull((Object)rr.getTTL(), (String)("TTL cannot be null for " + rr));
        Assert.assertNotNull((Object)rr.getRData(), (String)("InfoValues cannot be null for " + rr));
    }

    static void checkResourceRecordMetadata(ResourceRecordDetail rr) {
        Assert.assertNotNull((Object)rr.getZoneId(), (String)("ZoneId cannot be null for " + rr));
        Assert.assertNotNull((Object)rr.getGuid(), (String)("Guid cannot be null for " + rr));
        Assert.assertNotNull((Object)rr.getZoneName(), (String)("ZoneName cannot be null for " + rr));
        Assert.assertNotNull((Object)rr.getCreated(), (String)("Created cannot be null for " + rr));
        Assert.assertNotNull((Object)rr.getModified(), (String)("Modified cannot be null for " + rr));
        ResourceRecordApiLiveTest.checkResourceRecord(rr.getRecord());
    }

    @Test
    public void testListResourceRecords() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            this.zones.incrementAndGet();
            for (ResourceRecordDetail rr : this.api(zone.getName()).list()) {
                ((AtomicLong)this.recordTypeCounts.getUnchecked((Object)rr.getRecord().getType())).incrementAndGet();
                ResourceRecordApiLiveTest.checkResourceRecordMetadata(rr);
            }
        }
    }

    @AfterClass
    void logSummary() {
        Logger.getAnonymousLogger().info("zoneCount: " + this.zones);
        for (Map.Entry entry : this.recordTypeCounts.asMap().entrySet()) {
            Logger.getAnonymousLogger().info(String.format("type: %s, count: %s", entry.getKey(), entry.getValue()));
        }
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Zone does not exist in the system.")
    public void testListResourceRecordsWhenZoneIdNotFound() {
        this.api("AAAAAAAAAAAAAAAA").list();
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="No Resource Record with GUID found in the system")
    public void testUpdateWhenNotFound() {
        this.api(this.zoneName).update("AAAAAAAAAAAAAAAA", this.mx);
    }

    @Test
    public void testDeleteWhenNotFound() {
        this.api(this.zoneName).delete("AAAAAAAAAAAAAAAA");
    }

    @Test
    public void testCreateRecord() {
        this.guid = this.api(this.zoneName).create(this.mx);
        Logger.getAnonymousLogger().info("created record: " + this.guid);
        try {
            this.api(this.zoneName).create(this.mx);
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException resourceAlreadyExistsException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)this.listRRs().anyMatch(Predicates.equalTo((Object)this.mx)));
    }

    @Test(dependsOnMethods={"testCreateRecord"})
    public void testListResourceRecordsByName() {
        FluentIterable byName = this.api(this.zoneName).listByName(this.mx.getName()).transform(toRecord);
        Assert.assertTrue((boolean)byName.anyMatch(Predicates.equalTo((Object)this.mx)));
    }

    @Test(dependsOnMethods={"testCreateRecord"})
    public void testListResourceRecordsByNameAndType() {
        FluentIterable byNameAndType = this.api(this.zoneName).listByNameAndType(this.mx.getName(), this.mx.getType()).transform(toRecord);
        Assert.assertTrue((boolean)byNameAndType.anyMatch(Predicates.equalTo((Object)this.mx)));
    }

    @Test(dependsOnMethods={"testListResourceRecordsByName", "testListResourceRecordsByNameAndType"})
    public void testUpdateRecord() {
        this.mx = this.mx.toBuilder().ttl(3600).build();
        this.api(this.zoneName).update(this.guid, this.mx);
        Assert.assertTrue((boolean)this.listRRs().anyMatch(Predicates.equalTo((Object)this.mx)));
    }

    @Test(dependsOnMethods={"testUpdateRecord"})
    public void testDeleteRecord() {
        this.api(this.zoneName).delete(this.guid);
        Assert.assertFalse((boolean)this.listRRs().anyMatch(Predicates.equalTo((Object)this.mx)));
    }

    private FluentIterable<ResourceRecord> listRRs() {
        return this.api(this.zoneName).list().transform(toRecord);
    }

    private ResourceRecordApi api(String zoneName) {
        return ((UltraDNSWSApi)this.api).getResourceRecordApiForZone(zoneName);
    }
}

