/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.RoundRobinPool;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetRRLoadBalancingPoolsByZoneResponseTest;
import org.jclouds.ultradns.ws.parse.GetResourceRecordsOfResourceRecordResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="RoundRobinPoolApiExpectTest")
public class RoundRobinPoolApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest createA = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_rrpool_a.xml", "application/xml"))).build();
    HttpRequest createAAAA = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_rrpool_aaaa.xml", "application/xml"))).build();
    HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/rrpool_created.xml", "application/xml"))).build();
    HttpResponse alreadyCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResourceWithContentType("/lbpool_already_exists.xml", "application/xml"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_rrpools.xml", "application/xml"))).build();
    HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/rrpools.xml", "application/xml"))).build();
    HttpRequest listRecords = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_rrrecords.xml", "application/xml"))).build();
    HttpResponse listRecordsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/records.xml", "application/xml"))).build();
    HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/delete_lbpool.xml", "application/xml"))).build();
    HttpResponse deleteResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResourceWithContentType("/lbpool_deleted.xml", "application/xml"))).build();
    HttpResponse poolDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Epoolor").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/lbpool_doesnt_exist.xml"))).build();

    public void testCreateAWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.createA, this.createResponse);
        Assert.assertEquals((String)success.getRoundRobinPoolApiForZone("jclouds.org.").createForDNameAndType("www.jclouds.org.", "foo", RoundRobinPool.RecordType.A.getCode()), (String)"060339AA04175655");
    }

    public void testCreateAAAAWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.createAAAA, this.createResponse);
        Assert.assertEquals((String)success.getRoundRobinPoolApiForZone("jclouds.org.").createForDNameAndType("www.jclouds.org.", "foo", RoundRobinPool.RecordType.AAAA.getCode()), (String)"060339AA04175655");
    }

    @Test(expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class}, expectedExceptionsMessageRegExp="Pool already created for this host name : www.rrpool.adrianc.rrpool.ultradnstest.jclouds.org.")
    public void testCreateWhenResponseError2912() {
        UltraDNSWSApi already = (UltraDNSWSApi)this.requestSendsResponse(this.createA, this.alreadyCreated);
        already.getRoundRobinPoolApiForZone("jclouds.org.").createForDNameAndType("www.jclouds.org.", "foo", RoundRobinPool.RecordType.A.getCode());
    }

    public void testListWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.list, this.listResponse);
        Assert.assertEquals((String)success.getRoundRobinPoolApiForZone("jclouds.org.").list().toString(), (String)new GetRRLoadBalancingPoolsByZoneResponseTest().expected().toString());
    }

    public void testListRecordsWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listRecords, this.listRecordsResponse);
        Assert.assertEquals((String)success.getRoundRobinPoolApiForZone("jclouds.org.").listRecords("04053D8E57C7931F").toString(), (String)new GetResourceRecordsOfResourceRecordResponseTest().expected().toString());
    }

    public void testDeleteWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.deleteResponse);
        success.getRoundRobinPoolApiForZone("jclouds.org.").delete("04053D8E57C7931F");
    }

    public void testDeleteWhenResponseRRNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.poolDoesntExist);
        notFound.getRoundRobinPoolApiForZone("jclouds.org.").delete("04053D8E57C7931F");
    }
}

