/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.domain.Task;
import org.jclouds.ultradns.ws.features.TaskApi;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="TaskApiLiveTest")
public class TaskApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    private void checkTask(Task task) {
        Assert.assertNotNull((Object)task.getGuid(), (String)("Guid cannot be null for " + task));
        Assert.assertNotNull((Object)task.getStatusCode(), (String)("StatusCode cannot be null for " + task));
        Assert.assertNotNull((Object)task.getMessage(), (String)("While Message can be null, its Optional wrapper cannot " + task));
        Assert.assertNotNull((Object)task.getResultUrl(), (String)("While ResultUrl can be null, its Optional wrapper cannot " + task));
    }

    @Test
    public void testListTasks() {
        for (Task task : this.api().list()) {
            this.checkTask(task);
        }
    }

    @Test
    public void testGetTask() {
        for (Task task : this.api().list()) {
            Task got = this.api().get(task.getGuid());
            Assert.assertEquals((String)got.getGuid(), (String)task.getGuid());
            Assert.assertEquals((Object)got.getStatusCode(), (Object)task.getStatusCode());
            Assert.assertEquals((Object)got.getMessage(), (Object)task.getMessage());
            Assert.assertEquals((Object)got.getResultUrl(), (Object)task.getResultUrl());
        }
    }

    @Test
    public void testClearTask() {
        String guid = this.api().runTest("foo");
        this.checkTask(this.api().get(guid));
        this.api().clear(guid);
        Assert.assertNull((Object)this.api().get(guid));
    }

    @Test
    public void testClearTaskWhenNotFound() {
        this.api().clear("AAAAAAAAAAAAAAAA");
    }

    @Test
    public void testGetTaskWhenNotFound() {
        Assert.assertNull((Object)this.api().get("AAAAAAAAAAAAAAAA"));
    }

    protected TaskApi api() {
        return ((UltraDNSWSApi)this.api).getTaskApi();
    }
}

