/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import javax.ws.rs.core.Response;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.TrafficControllerPool;
import org.jclouds.ultradns.ws.domain.UpdatePoolRecord;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiExpectTest;
import org.jclouds.ultradns.ws.parse.GetPoolRecordSpecResponseTest;
import org.jclouds.ultradns.ws.parse.GetTCLoadBalancingPoolsByZoneResponseTest;
import org.jclouds.ultradns.ws.parse.GetTCPoolRecordsResponseTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TrafficControllerPoolApiExpectTest")
public class TrafficControllerPoolApiExpectTest
extends BaseUltraDNSWSApiExpectTest {
    HttpRequest create = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_tcpool.xml", "application/xml"))).build();
    HttpResponse createResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/tcpool_created.xml", "application/xml"))).build();
    HttpResponse alreadyCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResourceWithContentType("/lbpool_already_exists.xml", "application/xml"))).build();
    HttpRequest list = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_tcpools.xml", "application/xml"))).build();
    HttpResponse listResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/tcpools.xml", "application/xml"))).build();
    HttpRequest listRecords = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/list_tcrecords.xml", "application/xml"))).build();
    HttpResponse listRecordsResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/tcrecords.xml", "application/xml"))).build();
    HttpRequest getNameByDName = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/get_tcpool_by_dname.xml", "application/xml"))).build();
    HttpResponse getNameByDNameResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/tcpool_name.xml", "application/xml"))).build();
    HttpResponse poolDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Epoolor").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/lbpool_doesnt_exist.xml"))).build();
    HttpRequest delete = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/delete_lbpool.xml", "application/xml"))).build();
    HttpResponse deleteResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResourceWithContentType("/lbpool_deleted.xml", "application/xml"))).build();
    HttpRequest createRecord = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_tcrecord.xml", "application/xml"))).build();
    HttpResponse createRecordResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/tcrecord_created.xml", "application/xml"))).build();
    HttpResponse recordAlreadyCreated = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResourceWithContentType("/tcrecord_already_exists.xml", "application/xml"))).build();
    HttpRequest createRecordWithWeight = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/create_tcrecord_weight.xml", "application/xml"))).build();
    HttpRequest getRecordSpec = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/get_poolrecordspec.xml", "application/xml"))).build();
    HttpResponse getRecordSpecResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/poolrecordspec.xml", "application/xml"))).build();
    HttpResponse recordDoesntExist = ((HttpResponse.Builder)HttpResponse.builder().message("Server Error").statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/tcrecord_doesnt_exist.xml"))).build();
    UpdatePoolRecord update = UpdatePoolRecord.builder().rdata("www.baz.com.").mode("Normal").weight(98).failOverDelay(0).threshold(1).ttl(Response.Status.OK.getStatusCode()).build();
    HttpRequest updateRecord = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/update_poolrecord.xml", "application/xml"))).build();
    HttpResponse updateRecordResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(Response.Status.OK.getStatusCode()).payload(this.payloadFromResourceWithContentType("/poolrecord_updated.xml", "application/xml"))).build();
    HttpRequest deleteRecord = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResourceWithContentType("/delete_tcrecord.xml", "application/xml"))).build();
    HttpResponse deleteRecordResponse = ((HttpResponse.Builder)HttpResponse.builder().statusCode(404).payload(this.payloadFromResourceWithContentType("/tcrecord_deleted.xml", "application/xml"))).build();

    public void testCreateWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.createResponse);
        Assert.assertEquals((String)success.getTrafficControllerPoolApiForZone("jclouds.org.").createForDNameAndType("foo", "www.jclouds.org.", TrafficControllerPool.RecordType.IPV4.getCode()), (String)"060339AA0417567A");
    }

    @Test(expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class}, expectedExceptionsMessageRegExp="Pool already created for this host name : www.rrpool.adrianc.rrpool.ultradnstest.jclouds.org.")
    public void testCreateWhenResponseError2912() {
        UltraDNSWSApi already = (UltraDNSWSApi)this.requestSendsResponse(this.create, this.alreadyCreated);
        already.getTrafficControllerPoolApiForZone("jclouds.org.").createForDNameAndType("foo", "www.jclouds.org.", TrafficControllerPool.RecordType.IPV4.getCode());
    }

    public void testListWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.list, this.listResponse);
        Assert.assertEquals((String)success.getTrafficControllerPoolApiForZone("jclouds.org.").list().toString(), (String)new GetTCLoadBalancingPoolsByZoneResponseTest().expected().toString());
    }

    public void testListRecordsWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.listRecords, this.listRecordsResponse);
        Assert.assertEquals((String)success.getTrafficControllerPoolApiForZone("jclouds.org.").listRecords("04053D8E57C7931F").toString(), (String)new GetTCPoolRecordsResponseTest().expected().toString());
    }

    public void testGetNameByDNameWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.getNameByDName, this.getNameByDNameResponse);
        Assert.assertEquals((String)success.getTrafficControllerPoolApiForZone("jclouds.org.").getNameByDName("www.foo.com."), (String)"foo");
    }

    public void testGetNameByDNameWhenResponseNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.getNameByDName, this.poolDoesntExist);
        Assert.assertNull((Object)notFound.getTrafficControllerPoolApiForZone("jclouds.org.").getNameByDName("www.foo.com."));
    }

    public void testDeleteWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.deleteResponse);
        success.getTrafficControllerPoolApiForZone("jclouds.org.").delete("04053D8E57C7931F");
    }

    public void testDeleteWhenResponseNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.delete, this.poolDoesntExist);
        notFound.getTrafficControllerPoolApiForZone("jclouds.org.").delete("04053D8E57C7931F");
    }

    public void testCreateRecordWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.createRecord, this.createRecordResponse);
        Assert.assertEquals((String)success.getTrafficControllerPoolApiForZone("jclouds.org.").addRecordToPoolWithTTL("1.2.3.4", "04053D8E57C7931F", 300), (String)"06063DAC54F8D3D9");
    }

    @Test(expectedExceptions={UltraDNSWSExceptions.ResourceAlreadyExistsException.class}, expectedExceptionsMessageRegExp="Resource Record of type 1 with these attributes already exists in the system.")
    public void testCreateWhenResponseError1802() {
        UltraDNSWSApi already = (UltraDNSWSApi)this.requestSendsResponse(this.createRecord, this.recordAlreadyCreated);
        already.getTrafficControllerPoolApiForZone("jclouds.org.").addRecordToPoolWithTTL("1.2.3.4", "04053D8E57C7931F", 300);
    }

    public void testCreateRecordWithWeightWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.createRecordWithWeight, this.createRecordResponse);
        Assert.assertEquals((String)success.getTrafficControllerPoolApiForZone("jclouds.org.").addRecordToPoolWithTTLAndWeight("1.2.3.4", "04053D8E57C7931F", 300, 0), (String)"06063DAC54F8D3D9");
    }

    public void testGetRecordSpecWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.getRecordSpec, this.getRecordSpecResponse);
        Assert.assertEquals((Object)success.getTrafficControllerPoolApiForZone("jclouds.org.").getRecordSpec("04053D8E57C7931F"), (Object)new GetPoolRecordSpecResponseTest().expected());
    }

    public void testGetRecordSpecWhenResponseNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.getRecordSpec, this.recordDoesntExist);
        Assert.assertNull((Object)notFound.getTrafficControllerPoolApiForZone("jclouds.org.").getRecordSpec("04053D8E57C7931F"));
    }

    public void testUpdateRecordWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.updateRecord, this.updateRecordResponse);
        success.getTrafficControllerPoolApiForZone("jclouds.org.").updateRecord("04053D8E57C7931F", this.update);
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Pool Record does not exist.")
    public void testUpdateRecordWhenResponseNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.updateRecord, this.recordDoesntExist);
        notFound.getTrafficControllerPoolApiForZone("jclouds.org.").updateRecord("04053D8E57C7931F", this.update);
    }

    public void testDeleteRecordWhenResponseIs2xx() {
        UltraDNSWSApi success = (UltraDNSWSApi)this.requestSendsResponse(this.deleteRecord, this.deleteRecordResponse);
        success.getTrafficControllerPoolApiForZone("jclouds.org.").deleteRecord("04053D8E57C7931F");
    }

    public void testDeleteRecordWhenResponseNotFound() {
        UltraDNSWSApi notFound = (UltraDNSWSApi)this.requestSendsResponse(this.deleteRecord, this.recordDoesntExist);
        notFound.getTrafficControllerPoolApiForZone("jclouds.org.").deleteRecord("04053D8E57C7931F");
    }
}

