/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.PoolRecordSpec;
import org.jclouds.ultradns.ws.domain.TrafficControllerPool;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecord;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.UpdatePoolRecord;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.features.TrafficControllerPoolApi;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.jclouds.ultradns.ws.predicates.TrafficControllerPoolPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"live"}, singleThreaded=true, testName="TrafficControllerPoolApiLiveTest")
public class TrafficControllerPoolApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    String dname;
    String poolId;
    String cname1;
    String cname2;

    public TrafficControllerPoolApiLiveTest() {
        this.dname = "www.tcpool." + this.zoneName;
    }

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.createZone();
    }

    private void checkTCPool(TrafficControllerPool pool) {
        Assert.assertNotNull((Object)pool.getZoneId(), (String)("ZoneId cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getId(), (String)("Id cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getName(), (String)("Name cannot be null " + pool));
        Assert.assertNotNull((Object)pool.getDName(), (String)("DName cannot be null " + pool));
        Assert.assertEquals((String)this.api(this.zoneName).getNameByDName(pool.getDName()), (String)pool.getName());
    }

    @Test
    public void testListTCPools() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            for (TrafficControllerPool pool : this.api(zone.getName()).list()) {
                this.checkTCPool(pool);
            }
        }
    }

    @Test
    public void testListTCPoolRecords() {
        for (Zone zone : ((UltraDNSWSApi)this.api).getZoneApi().listByAccount(this.account.getId())) {
            for (TrafficControllerPool pool : this.api(zone.getName()).list()) {
                for (TrafficControllerPoolRecordDetail record : this.api(zone.getName()).listRecords(pool.getId())) {
                    this.checkPoolRecordConsistent(zone.getName(), record);
                }
            }
        }
    }

    private TrafficControllerPoolRecordDetail checkPoolRecordConsistent(String zoneName, TrafficControllerPoolRecordDetail record) {
        Optional<TrafficControllerPool> pool = this.getPoolByZoneAndId(zoneName, record.getPoolId());
        Assert.assertTrue((boolean)pool.isPresent(), (String)("could not get pool for " + record));
        Assert.assertEquals((String)record.getDescription(), (String)((TrafficControllerPool)pool.get()).getName());
        PoolRecordSpec spec = TrafficControllerPoolApiLiveTest.checkPoolRecordSpec(this.api(zoneName).getRecordSpec(record.getId()));
        Assert.assertEquals((String)record.getDescription(), (String)spec.getDescription());
        Assert.assertEquals((int)record.getWeight(), (int)spec.getWeight());
        Assert.assertEquals((boolean)record.isProbingEnabled(), (boolean)spec.isProbingEnabled());
        return TrafficControllerPoolApiLiveTest.checkTrafficControllerPoolRecord(record);
    }

    static TrafficControllerPoolRecordDetail checkTrafficControllerPoolRecord(TrafficControllerPoolRecordDetail record) {
        Assert.assertNotNull((Object)record.getId(), (String)("Id cannot be null for " + record));
        Assert.assertNotNull((Object)record.getPoolId(), (String)("PoolId cannot be null for " + record));
        Assert.assertNotNull((Object)record.getRecord().getRData(), (String)("Record.RData cannot be null for " + record));
        Assert.assertNotNull((Object)record.getRecord().getType(), (String)("Record.Type cannot be null for " + record));
        Assert.assertTrue((record.getWeight() >= 0 ? 1 : 0) != 0, (String)("Weight must be unsigned for " + record));
        Assert.assertTrue((record.getPriority() >= 0 ? 1 : 0) != 0, (String)("Priority must be unsigned for " + record));
        Assert.assertNotNull((Object)record.getStatus(), (String)("Status cannot be null for " + record));
        Assert.assertTrue((record.getStatus() != TrafficControllerPoolRecordDetail.Status.UNRECOGNIZED ? 1 : 0) != 0, (String)("unrecognized status for " + record));
        Assert.assertNotNull((Object)record.getDescription(), (String)("Description cannot be null for " + record));
        return record;
    }

    static PoolRecordSpec checkPoolRecordSpec(PoolRecordSpec record) {
        Assert.assertNotNull((Object)record.getDescription(), (String)("Description cannot be null for " + record));
        Assert.assertNotNull((Object)record.getState(), (String)("State cannot be null for " + record));
        Assert.assertTrue((boolean)ImmutableSet.of((Object)"Normal", (Object)"Normal-NoTest").contains((Object)record.getState()), (String)("Unknown State for " + record));
        Assert.assertTrue((record.getWeight() >= 0 ? 1 : 0) != 0, (String)("Weight must be unsigned for " + record));
        Assert.assertTrue((record.getFailOverDelay() >= 0 ? 1 : 0) != 0, (String)("failOverDelay must be unsigned for " + record));
        Assert.assertTrue((record.getThreshold() >= 0 ? 1 : 0) != 0, (String)("threshold must be unsigned for " + record));
        Assert.assertTrue((record.getTTL() >= 0 ? 1 : 0) != 0, (String)("ttl must be unsigned for " + record));
        return record;
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Zone does not exist in the system.")
    public void testListTCPoolsWhenZoneIdNotFound() {
        this.api("AAAAAAAAAAAAAAAA").list();
    }

    @Test
    public void testDeleteWhenNotFound() {
        this.api(this.zoneName).delete("06063D9C54C5AE09");
    }

    @Test
    public void testDeleteRecordWhenNotFound() {
        this.api(this.zoneName).deleteRecord("06063D9C54C5AE09");
    }

    @Test
    public void testGetNameByDNameWhenNotFound() {
        Assert.assertNull((Object)this.api(this.zoneName).getNameByDName("www.razzledazzle.cn."));
    }

    @Test
    public void testGetRecordSpecWhenNotFound() {
        Assert.assertNull((Object)this.api(this.zoneName).getRecordSpec("06063D9C54C5AE09"));
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Pool Record does not exist.")
    public void testUpdateRecordWhenNotFound() {
        this.api(this.zoneName).updateRecord("06063D9C54C5AE09", UpdatePoolRecord.builder().rdata("www.foo.com.").mode("Normal").build());
    }

    @Test
    public void testCreatePool() {
        this.poolId = this.api(this.zoneName).createForDNameAndType("pool", this.dname, TrafficControllerPool.RecordType.IPV4.getCode());
        Logger.getAnonymousLogger().info("created tc pool: " + this.poolId);
        try {
            this.api(this.zoneName).createForDNameAndType("pool", this.dname, TrafficControllerPool.RecordType.IPV4.getCode());
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException e) {
            // empty catch block
        }
        try {
            this.api(this.zoneName).createForDNameAndType("pool1", this.dname, TrafficControllerPool.RecordType.IPV4.getCode());
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException e) {
            // empty catch block
        }
        Optional<TrafficControllerPool> pool = this.getPoolByZoneAndId(this.zoneName, this.poolId);
        Assert.assertTrue((boolean)pool.isPresent());
        Assert.assertEquals((String)((TrafficControllerPool)pool.get()).getId(), (String)this.poolId);
        Assert.assertEquals((String)((TrafficControllerPool)pool.get()).getName(), (String)"pool");
        Assert.assertEquals((String)((TrafficControllerPool)pool.get()).getDName(), (String)this.dname);
        this.checkTCPool((TrafficControllerPool)pool.get());
    }

    @DataProvider(name="records")
    public Object[][] createRecords() {
        Object[][] records = new Object[2][4];
        records[0][0] = "1.2.3.4";
        records[0][1] = "A";
        records[0][2] = 60;
        records[0][3] = Optional.of((Object)98);
        records[1][0] = "5.6.7.8";
        records[1][1] = "A";
        records[1][2] = 60;
        records[1][3] = Optional.of((Object)2);
        return records;
    }

    @Test(dependsOnMethods={"testCreatePool"}, dataProvider="records")
    public TrafficControllerPoolRecordDetail addRecordToPool(String rdata, String type, int ttl, Optional<Integer> weight) {
        String recordId = weight.isPresent() ? this.api(this.zoneName).addRecordToPoolWithTTLAndWeight(rdata, this.poolId, ttl, ((Integer)weight.get()).intValue()) : this.api(this.zoneName).addRecordToPoolWithTTL(rdata, this.poolId, ttl);
        Logger.getAnonymousLogger().info("created " + type + " record: " + recordId);
        TrafficControllerPoolRecordDetail record = this.checkPoolRecordConsistent(this.zoneName, (TrafficControllerPoolRecordDetail)this.getRecordById(recordId).get());
        PoolRecordSpec recordSpec = TrafficControllerPoolApiLiveTest.checkPoolRecordSpec(this.api(this.zoneName).getRecordSpec(recordId));
        Assert.assertEquals((Object)record.getRecord(), (Object)TrafficControllerPoolRecord.create((String)type, (String)rdata));
        Assert.assertEquals((int)record.getWeight(), (int)((Integer)weight.or((Object)2)));
        Assert.assertEquals((int)recordSpec.getTTL(), (int)ttl);
        return record;
    }

    @Test(dependsOnMethods={"testCreatePool"})
    public void addCNAMERecordsToPool() {
        this.cname1 = this.addRecordToPool("www.foo.com.", "CNAME", 30, (Optional<Integer>)Optional.absent()).getId();
        try {
            this.api(this.zoneName).addRecordToPoolWithTTL("www.foo.com.", this.poolId, 30);
            Assert.fail();
        }
        catch (UltraDNSWSExceptions.ResourceAlreadyExistsException resourceAlreadyExistsException) {
            // empty catch block
        }
        this.cname2 = this.addRecordToPool("www.bar.com.", "CNAME", 30, (Optional<Integer>)Optional.absent()).getId();
    }

    @Test(dependsOnMethods={"addCNAMERecordsToPool"})
    public void testUpdateRecord() {
        PoolRecordSpec spec = this.api(this.zoneName).getRecordSpec(this.cname2);
        UpdatePoolRecord update = UpdatePoolRecord.builder().from(spec).rdata("www.baz.com.").weight(98).ttl(200).build();
        this.api(this.zoneName).updateRecord(this.cname2, update);
        TrafficControllerPoolRecordDetail record = (TrafficControllerPoolRecordDetail)this.getRecordById(this.cname2).get();
        Assert.assertEquals((String)record.getRecord().getRData(), (String)"www.baz.com.");
        spec = this.api(this.zoneName).getRecordSpec(this.cname2);
        Assert.assertEquals((int)spec.getWeight(), (int)98);
        Assert.assertEquals((int)spec.getTTL(), (int)200);
    }

    @Test(dependsOnMethods={"testUpdateRecord"})
    public void testDeleteRecord() {
        this.api(this.zoneName).deleteRecord(this.cname1);
        Assert.assertFalse((boolean)this.getRecordById(this.cname1).isPresent());
        Assert.assertTrue((boolean)this.getRecordById(this.cname2).isPresent());
    }

    @Test(dependsOnMethods={"testDeleteRecord"})
    public void testDeletePool() {
        this.api(this.zoneName).delete(this.poolId);
        Assert.assertFalse((boolean)this.getPoolByZoneAndId(this.zoneName, this.poolId).isPresent());
    }

    private Optional<TrafficControllerPoolRecordDetail> getRecordById(String recordId) {
        return this.api(this.zoneName).listRecords(this.poolId).firstMatch(TrafficControllerPoolPredicates.recordIdEqualTo((String)recordId));
    }

    private Optional<TrafficControllerPool> getPoolByZoneAndId(String zoneName, String poolId) {
        return this.api(zoneName).list().firstMatch(TrafficControllerPoolPredicates.idEqualTo((String)poolId));
    }

    private TrafficControllerPoolApi api(String zoneName) {
        return ((UltraDNSWSApi)this.api).getTrafficControllerPoolApiForZone(zoneName);
    }

    @Override
    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.poolId != null) {
            this.api(this.zoneName).delete(this.poolId);
        }
        super.tearDown();
    }
}

