/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import java.util.Set;
import java.util.logging.Logger;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.domain.ZoneProperties;
import org.jclouds.ultradns.ws.features.ZoneApi;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.jclouds.ultradns.ws.predicates.ZonePredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="ZoneApiLiveTest")
public class ZoneApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    private void checkZone(Zone zone) {
        Assert.assertNotNull((Object)zone.getId(), (String)("Id cannot be null for " + zone));
        Assert.assertNotNull((Object)zone.getName(), (String)("Name cannot be null for " + zone));
        Assert.assertNotNull((Object)zone.getType(), (String)("Type cannot be null for " + zone));
        Assert.assertNotNull((Object)zone.getTypeCode(), (String)("TypeCode cannot be null for " + zone));
        Assert.assertEquals((int)zone.getTypeCode(), (int)zone.getType().getCode());
        Assert.assertNotNull((Object)zone.getAccountId(), (String)("AccountId cannot be null for " + zone));
        Assert.assertEquals((String)zone.getAccountId(), (String)this.account.getId());
        Assert.assertNotNull((Object)zone.getOwnerId(), (String)("OwnerId cannot be null for " + zone));
        Assert.assertNotNull((Object)zone.getDNSSECStatus(), (String)("DNSSECStatus cannot be null for " + zone));
        Assert.assertNotNull((Object)zone.getPrimarySrc(), (String)("While PrimarySrc can be null, its Optional wrapper cannot " + zone));
    }

    @Test
    public void testListZonesByAccount() {
        FluentIterable response = this.api().listByAccount(this.account.getId());
        for (Zone zone : response) {
            this.checkZone(zone);
        }
        if (response.anyMatch(ZonePredicates.typeEqualTo((Zone.Type)Zone.Type.PRIMARY))) {
            Assert.assertEquals((Set)this.api().listByAccountAndType(this.account.getId(), Zone.Type.PRIMARY).toSet(), (Set)response.filter(ZonePredicates.typeEqualTo((Zone.Type)Zone.Type.PRIMARY)).toSet());
        }
    }

    @Test
    public void testListZonesByAccountWhenAccountIdNotFound() {
        Assert.assertTrue((boolean)this.api().listByAccount("AAAAAAAAAAAAAAAA").isEmpty());
    }

    @Test
    public void testGetZone() {
        for (Zone zone : this.api().listByAccount(this.account.getId())) {
            ZoneProperties zoneProperties = this.api().get(zone.getName());
            Assert.assertEquals((String)zoneProperties.getName(), (String)zone.getName());
            Assert.assertEquals((Object)zoneProperties.getType(), (Object)zone.getType());
            Assert.assertEquals((int)zoneProperties.getTypeCode(), (int)zone.getTypeCode());
            Assert.assertNotNull((Object)zoneProperties.getModified(), (String)("Modified cannot be null for " + zone));
            Assert.assertTrue((zoneProperties.getResourceRecordCount() >= 0 ? 1 : 0) != 0, (String)("ResourceRecordCount must be positive or zero for a Zone " + zone));
        }
    }

    @Test
    public void testGetZoneWhenNotFound() {
        Assert.assertNull((Object)this.api().get("AAAAAAAAAAAAAAAA"));
    }

    @Test
    public void testDeleteZoneWhenNotFound() {
        this.api().delete("AAAAAAAAAAAAAAAA");
    }

    @Test(expectedExceptions={ResourceNotFoundException.class}, expectedExceptionsMessageRegExp="Account not found in the system. ID: AAAAAAAAAAAAAAAA")
    public void testCreateZoneBadAccountId() {
        this.api().createInAccount(this.zoneName, "AAAAAAAAAAAAAAAA");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAndDeleteZone() {
        try {
            this.api().createInAccount(this.zoneName, this.account.getId());
            ZoneProperties newZone = this.api().get(this.zoneName);
            Logger.getAnonymousLogger().info("created zone: " + newZone);
            try {
                this.api().createInAccount(this.zoneName, this.account.getId());
                Assert.fail();
            }
            catch (UltraDNSWSExceptions.ResourceAlreadyExistsException resourceAlreadyExistsException) {
                // empty catch block
            }
            Assert.assertEquals((String)newZone.getName(), (String)this.zoneName);
            Assert.assertEquals((Object)newZone.getType(), (Object)Zone.Type.PRIMARY);
            Assert.assertEquals((int)newZone.getTypeCode(), (int)Zone.Type.PRIMARY.getCode());
            Assert.assertNotNull((Object)newZone.getModified(), (String)("Modified cannot be null for " + newZone));
            Assert.assertEquals((int)newZone.getResourceRecordCount(), (int)5);
        }
        finally {
            this.api().delete(this.zoneName);
        }
    }

    protected ZoneApi api() {
        return ((UltraDNSWSApi)this.api).getZoneApi();
    }
}

