/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.handlers;

import com.google.common.base.Throwables;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.io.Payload;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.internal.BaseRestApiExpectTest;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.UltraDNSWSResponseException;
import org.jclouds.ultradns.ws.handlers.UltraDNSWSErrorHandler;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class UltraDNSWSErrorHandlerTest {
    UltraDNSWSErrorHandler function = (UltraDNSWSErrorHandler)Guice.createInjector((Module[])new Module[]{new SaxParserModule()}).getInstance(UltraDNSWSErrorHandler.class);

    @Test
    public void testCode0SetsUltraDNSWSResponseException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/list_tasks.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/server_fault.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), UltraDNSWSResponseException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Error 0");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException());
        Assert.assertEquals((int)exception.getError().getCode(), (int)0);
    }

    @Test
    public void testCode0ForDescriptionMatchingCannotFindSetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/list_tasks.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/task_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Cannot find task with guid AAAAAAAAAAAAAAAA");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 0: Cannot find task with guid AAAAAAAAAAAAAAAA");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Cannot find task with guid AAAAAAAAAAAAAAAA");
        Assert.assertEquals((int)exception.getError().getCode(), (int)0);
    }

    @Test
    public void testCode2401SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/list_zones_by_account.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/account_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Account not found in the system. ID: AAAAAAAAAAAAAAAA");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 2401: Account not found in the system. ID: AAAAAAAAAAAAAAAA");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Account not found in the system. ID: AAAAAAAAAAAAAAAA");
        Assert.assertEquals((int)exception.getError().getCode(), (int)2401);
    }

    @Test
    public void testCode1801SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/get_zone.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/zone_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Zone does not exist in the system.");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 1801: Zone does not exist in the system.");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Zone does not exist in the system.");
        Assert.assertEquals((int)exception.getError().getCode(), (int)1801);
    }

    @Test
    public void testCode2103SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/delete_rr.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/rr_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"No Resource Record with GUID found in the system AAAAAAAAAAAAAAAA");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 2103: No Resource Record with GUID found in the system AAAAAAAAAAAAAAAA");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"No Resource Record with GUID found in the system AAAAAAAAAAAAAAAA");
        Assert.assertEquals((int)exception.getError().getCode(), (int)2103);
    }

    @Test
    public void testCode1802SetsResourceAlreadyExistsException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/create_zone.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/zone_already_exists.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), UltraDNSWSExceptions.ResourceAlreadyExistsException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Zone already exists in the system.");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 1802: Zone already exists in the system.");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Zone already exists in the system.");
        Assert.assertEquals((int)exception.getError().getCode(), (int)1802);
    }

    @Test
    public void testCode2111SetsResourceAlreadyExistsException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/create_rr.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/rr_already_exists.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), UltraDNSWSExceptions.ResourceAlreadyExistsException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Resource Record of type 15 with these attributes already exists in the system.");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 2111: Resource Record of type 15 with these attributes already exists in the system.");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Resource Record of type 15 with these attributes already exists in the system.");
        Assert.assertEquals((int)exception.getError().getCode(), (int)2111);
    }

    @Test
    public void testCode2911SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/delete_lbpool.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/lbpool_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Pool does not exist in the system");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 2911: Pool does not exist in the system");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Pool does not exist in the system");
        Assert.assertEquals((int)exception.getError().getCode(), (int)2911);
    }

    @Test
    public void testCode2142SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/delete_lbpool.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/directionalpool_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"No Pool or Multiple pools of same type exists for the PoolName : foo.jclouds.org.");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 2142: No Pool or Multiple pools of same type exists for the PoolName : foo.jclouds.org.");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"No Pool or Multiple pools of same type exists for the PoolName : foo.jclouds.org.");
        Assert.assertEquals((int)exception.getError().getCode(), (int)2142);
    }

    @Test
    public void testCode2912SetsResourceAlreadyExistsException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/create_rrpool_a.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/lbpool_already_exists.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), UltraDNSWSExceptions.ResourceAlreadyExistsException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Pool already created for this host name : www.rrpool.adrianc.rrpool.ultradnstest.jclouds.org.");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 2912: Pool already created for this host name : www.rrpool.adrianc.rrpool.ultradnstest.jclouds.org.");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Pool already created for this host name : www.rrpool.adrianc.rrpool.ultradnstest.jclouds.org.");
        Assert.assertEquals((int)exception.getError().getCode(), (int)2912);
    }

    @Test
    public void testCode3101SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/delete_tcrecord.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/tcrecord_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Pool Record does not exist.");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 3101: Pool Record does not exist.");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Pool Record does not exist.");
        Assert.assertEquals((int)exception.getError().getCode(), (int)3101);
    }

    @Test
    public void testCode4003SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/delete_tcrecord.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/directionalgroup_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Group does not exist.");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 4003: Group does not exist.");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Group does not exist.");
        Assert.assertEquals((int)exception.getError().getCode(), (int)4003);
    }

    @Test
    public void testCode2705SetsResourceNotFoundException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/delete_directionalrecord.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/directionalrecord_doesnt_exist.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), ResourceNotFoundException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Directional Pool Record does not exist in the system");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 2705: Directional Pool Record does not exist in the system");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Directional Pool Record does not exist in the system");
        Assert.assertEquals((int)exception.getError().getCode(), (int)2705);
    }

    @Test
    public void testCode7021SetsDirectionalGroupOverlapException() throws IOException {
        HttpRequest request = ((HttpRequest.Builder)((HttpRequest.Builder)HttpRequest.builder().method("POST").endpoint("https://ultra-api.ultradns.com:8443/UltraDNS_WS/v01").addHeader("Host", new String[]{"ultra-api.ultradns.com:8443"})).payload(this.payloadFromResource("/create_directionalrecord_newgroup.xml"))).build();
        HttpCommand command = new HttpCommand(request);
        HttpResponse response = ((HttpResponse.Builder)HttpResponse.builder().message(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).payload(this.payloadFromResource("/directionalgroup_overlap.xml"))).build();
        this.function.handleError(command, response);
        Assert.assertEquals(command.getException().getClass(), UltraDNSWSExceptions.DirectionalGroupOverlapException.class);
        Assert.assertEquals((String)command.getException().getMessage(), (String)"Geolocation/Source IP overlap(s) found: Region: Utah (Group: US )");
        UltraDNSWSResponseException exception = (UltraDNSWSResponseException)UltraDNSWSResponseException.class.cast(command.getException().getCause());
        Assert.assertEquals((String)exception.getMessage(), (String)"Error 7021: Geolocation/Source IP overlap(s) found: Region: Utah (Group: US )");
        Assert.assertEquals((String)((String)exception.getError().getDescription().get()), (String)"Geolocation/Source IP overlap(s) found: Region: Utah (Group: US )");
        Assert.assertEquals((int)exception.getError().getCode(), (int)7021);
    }

    private Payload payloadFromResource(String resource) {
        try {
            return BaseRestApiExpectTest.payloadFromStringWithContentType((String)Strings2.toStringAndClose((InputStream)this.getClass().getResourceAsStream(resource)), (String)"application/xml");
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

