/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.internal;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.Collection;
import org.jclouds.ultradns.ws.UltraDNSWSApi;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.internal.BaseUltraDNSWSApiLiveTest;
import org.jclouds.ultradns.ws.predicates.DirectionalPoolPredicates;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BaseDirectionalApiLiveTest
extends BaseUltraDNSWSApiLiveTest {
    protected String dname;
    protected String cnamePoolId;
    protected String cnameEU;
    protected DirectionalGroup eu;
    protected DirectionalPoolRecord cnameRecordEU;
    protected String cnameUS;
    protected DirectionalGroup us;
    protected DirectionalPoolRecord cnameRecordUS;
    protected String cnameCanary;
    protected DirectionalGroup nebraska;
    protected DirectionalPoolRecord cnameRecordCanary;
    protected String cname2Canary;
    protected DirectionalPoolRecord cname2RecordCanary;
    protected String aPoolId;
    protected String a1Prod;
    protected DirectionalPoolRecord a1RecordProd;
    protected String a1Canary;
    protected DirectionalPoolRecord a1RecordCanary;
    public static final String REGION_US = "United States (US)";

    public BaseDirectionalApiLiveTest() {
        this.dname = "www." + this.zoneName;
        this.eu = null;
        this.cnameRecordEU = DirectionalPoolRecord.drBuilder().type("CNAME").ttl(8600).rdata((Object)("eu." + this.dname)).build();
        this.us = null;
        this.cnameRecordUS = DirectionalPoolRecord.drBuilder().type("CNAME").ttl(300).rdata((Object)("us." + this.dname)).build();
        this.nebraska = null;
        this.cnameRecordCanary = DirectionalPoolRecord.drBuilder().type("CNAME").ttl(300).rdata((Object)("canary." + this.dname)).build();
        this.cname2RecordCanary = this.cnameRecordCanary.toBuilder().rdata((Object)("parrot." + this.dname)).build();
        this.a1RecordProd = DirectionalPoolRecord.drBuilder().type("A").ttl(300).rdata((Object)"1.1.0.1").build();
        this.a1RecordCanary = DirectionalPoolRecord.drBuilder().type("A").ttl(300).rdata((Object)"1.1.1.1").build();
    }

    @Override
    @BeforeClass(groups={"integration", "live"})
    public void setup() {
        super.setup();
        this.setupGroups();
        this.createZone();
    }

    void setupGroups() {
        this.eu = DirectionalGroup.builder().name("EU").description("Clients we classify as being in Europe").mapRegion("Europe").build();
        this.nebraska = DirectionalGroup.builder().name("Canary").description("Clients who are testing our service").mapRegionToTerritory(REGION_US, "Nebraska").build();
        Multimap availableRegions = ((UltraDNSWSApi)this.api).getRegionsByIdAndName();
        Collection usTerritories = Multimaps.filterKeys((Multimap)availableRegions, (Predicate)IdAndName.nameEqualTo((String)REGION_US)).values();
        this.us = DirectionalGroup.builder().name("US").description("Clients we classify as being in US").mapRegionToTerritories(REGION_US, Iterables.filter((Iterable)usTerritories, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"Nebraska")))).build();
    }

    protected void checkGroupByDNameAndIdContainsTerritory(String dname, String poolRecordId, String territory) {
        DirectionalGroup regions = this.getGroup(dname, poolRecordId);
        Assert.assertTrue((boolean)regions.values().contains(territory), (String)(poolRecordId + " doesn't contain " + territory));
    }

    protected void checkGroupByDNameAndIdDoesntContainTerritory(String dname, String poolRecordId, String territory) {
        DirectionalGroup regions = this.getGroup(dname, poolRecordId);
        Assert.assertFalse((boolean)regions.values().contains(territory), (String)(poolRecordId + " contains " + territory));
    }

    private DirectionalGroup getGroup(String dname, String poolRecordId) {
        DirectionalPoolRecordDetail record = (DirectionalPoolRecordDetail)this.getRecordByDNameAndId(dname, poolRecordId).get();
        return ((UltraDNSWSApi)this.api).getDirectionalGroupApiForAccount(this.account.getId()).get(((IdAndName)record.getGeolocationGroup().or(record.getGroup()).get()).getId());
    }

    protected Optional<DirectionalPool> getPoolById(final String cnamePoolId) {
        return ((UltraDNSWSApi)this.api).getDirectionalPoolApiForZone(this.zoneName).list().firstMatch((Predicate)new Predicate<DirectionalPool>(){

            public boolean apply(DirectionalPool in) {
                return in.getId().equals(cnamePoolId);
            }
        });
    }

    protected Optional<DirectionalPoolRecordDetail> getRecordByDNameAndId(String dname, String recordId) {
        return ((UltraDNSWSApi)this.api).getDirectionalPoolApiForZone(this.zoneName).listRecordsByDNameAndType(dname, DirectionalPool.RecordType.IPV4.getCode()).firstMatch(DirectionalPoolPredicates.recordIdEqualTo((String)recordId));
    }

    @Override
    @AfterClass(groups={"integration", "live"})
    protected void tearDown() {
        if (this.cnamePoolId != null) {
            ((UltraDNSWSApi)this.api).getDirectionalPoolApiForZone(this.zoneName).delete(this.cnamePoolId);
        }
        if (this.aPoolId != null) {
            ((UltraDNSWSApi)this.api).getDirectionalPoolApiForZone(this.zoneName).delete(this.aPoolId);
        }
        super.tearDown();
    }
}

