/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.AccountLevelGroup;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.xml.AccountLevelGroupsHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetAccountLevelDirectionalGroupsResponseTest")
public class GetAccountLevelDirectionalGroupsResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/accountlevelgroups.xml");
        FluentIterable<AccountLevelGroup> expected = this.expected();
        AccountLevelGroupsHandler handler = (AccountLevelGroupsHandler)this.injector.getInstance(AccountLevelGroupsHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<AccountLevelGroup> expected() {
        return FluentIterable.from((Iterable)ImmutableList.builder().add((Object)AccountLevelGroup.builder().id("000000000000000A").name("ASIA").type(DirectionalPool.Type.GEOLOCATION).recordCount(0).build()).add((Object)AccountLevelGroup.builder().id("000000000000000B").name("EU").type(DirectionalPool.Type.GEOLOCATION).recordCount(3).build()).add((Object)AccountLevelGroup.builder().id("000000000000000C").name("LATAM").type(DirectionalPool.Type.GEOLOCATION).recordCount(1).build()).build());
    }
}

