/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.xml.RegionListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetAvailableRegionsResponseTest")
public class GetAvailableRegionsResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/regions.xml");
        Multimap<IdAndName, String> expected = this.expected();
        RegionListHandler handler = (RegionListHandler)this.injector.getInstance(RegionListHandler.class);
        Multimap result = (Multimap)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toString(), (String)expected.toString());
    }

    public Multimap<IdAndName, String> expected() {
        return ImmutableMultimap.builder().put((Object)IdAndName.create((String)"14", (String)"Anonymous Proxy (A1)"), (Object)"Anonymous Proxy").putAll((Object)IdAndName.create((String)"3", (String)"Antarctica"), (Iterable)ImmutableSet.builder().add((Object)"Antarctica").add((Object)"Bouvet Island").add((Object)"French Southern Territories").build()).build();
    }
}

