/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.RoundRobinPool;
import org.jclouds.ultradns.ws.xml.RoundRobinPoolListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetRRLoadBalancingPoolsByZoneResponseTest")
public class GetRRLoadBalancingPoolsByZoneResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/rrpools.xml");
        FluentIterable<RoundRobinPool> expected = this.expected();
        RoundRobinPoolListHandler handler = (RoundRobinPoolListHandler)this.injector.getInstance(RoundRobinPoolListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<RoundRobinPool> expected() {
        return FluentIterable.from((Iterable)ImmutableList.builder().add((Object)RoundRobinPool.builder().zoneId("0000000000000001").id("000000000000002").name("uswest1").dname("app-uswest1.jclouds.org.").build()).add((Object)RoundRobinPool.builder().zoneId("0000000000000001").id("000000000000003").name("uswest2").dname("app-uswest2.jclouds.org.").build()).add((Object)RoundRobinPool.builder().zoneId("0000000000000001").id("000000000000004").name("euwest").dname("app-euwest.jclouds.org.").build()).build());
    }
}

