/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.TrafficControllerPool;
import org.jclouds.ultradns.ws.xml.TrafficControllerPoolListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetTCLoadBalancingPoolsByZoneResponseTest")
public class GetTCLoadBalancingPoolsByZoneResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/tcpools.xml");
        FluentIterable<TrafficControllerPool> expected = this.expected();
        TrafficControllerPoolListHandler handler = (TrafficControllerPoolListHandler)this.injector.getInstance(TrafficControllerPoolListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<TrafficControllerPool> expected() {
        return FluentIterable.from((Iterable)ImmutableList.builder().add((Object)TrafficControllerPool.builder().zoneId("0000000000000001").id("000000000000002").name("us-west-1c").dname("us-west-1c.discovery.jclouds.org.").statusCode(1).failOverEnabled(true).probingEnabled(true).build()).build());
    }
}

