/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecord;
import org.jclouds.ultradns.ws.domain.TrafficControllerPoolRecordDetail;
import org.jclouds.ultradns.ws.xml.TrafficControllerPoolRecordDetailListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetTCPoolRecordsResponseTest")
public class GetTCPoolRecordsResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/tcrecords.xml");
        FluentIterable<TrafficControllerPoolRecordDetail> expected = this.expected();
        TrafficControllerPoolRecordDetailListHandler handler = (TrafficControllerPoolRecordDetailListHandler)this.injector.getInstance(TrafficControllerPoolRecordDetailListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<TrafficControllerPoolRecordDetail> expected() {
        return FluentIterable.from((Iterable)ImmutableSet.builder().add((Object)TrafficControllerPoolRecordDetail.builder().id("0000000000000001").poolId("0000000000000001").record(TrafficControllerPoolRecord.createCNAME((String)"canary.jclouds.org.")).weight(2).priority(2).forceAnswer("Normal").probingEnabled(true).status(TrafficControllerPoolRecordDetail.Status.OK).serving(true).description("canary app").build()).add((Object)TrafficControllerPoolRecordDetail.builder().id("0000000000000002").poolId("0000000000000001").record(TrafficControllerPoolRecord.createCNAME((String)"prod.jclouds.org.")).weight(98).priority(1).forceAnswer("Normal").probingEnabled(true).status(TrafficControllerPoolRecordDetail.Status.OK).serving(true).description("prod app").build()).build());
    }
}

