/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.parse;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Zone;
import org.jclouds.ultradns.ws.xml.ZoneListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="GetZonesOfAccountResponseTest")
public class GetZonesOfAccountResponseTest
extends BaseHandlerTest {
    public void test() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/zones.xml");
        FluentIterable<Zone> expected = this.expected();
        ZoneListHandler handler = (ZoneListHandler)this.injector.getInstance(ZoneListHandler.class);
        FluentIterable result = (FluentIterable)this.factory.create((ParseSax.HandlerWithResult)handler).parse(is);
        Assert.assertEquals((String)result.toSet().toString(), (String)expected.toSet().toString());
    }

    public FluentIterable<Zone> expected() {
        return FluentIterable.from((Iterable)ImmutableSet.builder().add((Object)Zone.builder().name("jclouds.org.").typeCode(1).accountId("AAAAAAAAAAAAAAAA").ownerId("EEEEEEEEEEEEEEEE").id("0000000000000001").dnssecStatus(Zone.DNSSECStatus.UNSIGNED).build()).add((Object)Zone.builder().name("0.1.2.3.4.5.6.7.ip6.arpa.").typeCode(1).accountId("AAAAAAAAAAAAAAAA").ownerId("EEEEEEEEEEEEEEEE").id("0000000000000002").dnssecStatus(Zone.DNSSECStatus.UNSIGNED).build()).build());
    }
}

