/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.predicates;

import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.domain.IdAndName;
import org.jclouds.ultradns.ws.predicates.DirectionalPoolPredicates;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="DirectionalPoolPredicatesTest")
public class DirectionalPoolPredicatesTest {
    DirectionalPool pool = DirectionalPool.builder().zoneId("0000000000000001").id("000000000000000A").dname("mixy.jclouds.org.").type(DirectionalPool.Type.MIXED).tieBreak(DirectionalPool.TieBreak.GEOLOCATION).name("mixy").build();
    DirectionalPoolRecordDetail record = DirectionalPoolRecordDetail.builder().zoneName("geo.jclouds.org.").name("www.geo.jclouds.org.").id("A000000000000001").geolocationGroup(IdAndName.create((String)"C000000000000001", (String)"southamerica")).record(DirectionalPoolRecord.drBuilder().type("CNAME").ttl(300).noResponseRecord(false).rdata((Object)"southamerica.geo.jclouds.org.").build()).build();

    @Test
    public void testIdEqualToWhenEqual() {
        Assert.assertTrue((boolean)DirectionalPoolPredicates.idEqualTo((String)"000000000000000A").apply((Object)this.pool));
    }

    @Test
    public void testIdEqualToWhenNotEqual() {
        Assert.assertFalse((boolean)DirectionalPoolPredicates.idEqualTo((String)"000000000000000B").apply((Object)this.pool));
    }

    @Test
    public void testRecordIdEqualToWhenEqual() {
        Assert.assertTrue((boolean)DirectionalPoolPredicates.recordIdEqualTo((String)"A000000000000001").apply((Object)this.record));
    }

    @Test
    public void testRecordIdEqualToWhenNotEqual() {
        Assert.assertFalse((boolean)DirectionalPoolPredicates.recordIdEqualTo((String)"A000000000000002").apply((Object)this.record));
    }
}

