/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.features;

import com.google.common.collect.FluentIterable;
import javax.inject.Named;
import javax.ws.rs.POST;
import org.jclouds.Fallbacks;
import org.jclouds.rest.ResourceNotFoundException;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.ParamParser;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.ultradns.ws.UltraDNSWSExceptions;
import org.jclouds.ultradns.ws.binders.DirectionalRecordAndGeoGroupToXML;
import org.jclouds.ultradns.ws.domain.DirectionalGroup;
import org.jclouds.ultradns.ws.domain.DirectionalPool;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecord;
import org.jclouds.ultradns.ws.domain.DirectionalPoolRecordDetail;
import org.jclouds.ultradns.ws.filters.SOAPWrapWithPasswordAuth;
import org.jclouds.ultradns.ws.internal.DirectionalPoolRecordTypeToString;
import org.jclouds.ultradns.ws.xml.DirectionalPoolListHandler;
import org.jclouds.ultradns.ws.xml.DirectionalPoolRecordDetailListHandler;
import org.jclouds.ultradns.ws.xml.ElementTextHandler;

@RequestFilters(value={SOAPWrapWithPasswordAuth.class})
@VirtualHost
public interface DirectionalPoolApi {
    @Named(value="getDirectionalPoolsOfZone")
    @POST
    @XMLResponseParser(value=DirectionalPoolListHandler.class)
    @Payload(value="<v01:getDirectionalPoolsOfZone><zoneName>{zoneName}</zoneName></v01:getDirectionalPoolsOfZone>")
    public FluentIterable<DirectionalPool> list() throws ResourceNotFoundException;

    @Named(value="getDirectionalDNSRecordsForHost")
    @POST
    @XMLResponseParser(value=DirectionalPoolRecordDetailListHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    @Payload(value="<v01:getDirectionalDNSRecordsForHost><zoneName>{zoneName}</zoneName><hostName>{hostName}</hostName><poolRecordType>{poolRecordType}</poolRecordType></v01:getDirectionalDNSRecordsForHost>")
    public FluentIterable<DirectionalPoolRecordDetail> listRecordsByDNameAndType(@PayloadParam(value="hostName") String var1, @PayloadParam(value="poolRecordType") int var2) throws ResourceNotFoundException;

    @Named(value="addDirectionalPool")
    @POST
    @XMLResponseParser(value=ElementTextHandler.DirPoolID.class)
    @Payload(value="<v01:addDirectionalPool><transactionID /><AddDirectionalPoolData dirPoolType=\"GEOLOCATION\" poolRecordType=\"{poolRecordType}\" zoneName=\"{zoneName}\" hostName=\"{hostName}\" description=\"{description}\"/></v01:addDirectionalPool>")
    public String createForDNameAndType(@PayloadParam(value="description") String var1, @PayloadParam(value="hostName") String var2, @PayloadParam(value="poolRecordType") @ParamParser(value=DirectionalPoolRecordTypeToString.class) int var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="addDirectionalPoolRecord")
    @POST
    @XMLResponseParser(value=ElementTextHandler.DirectionalPoolRecordID.class)
    @MapBinder(value=DirectionalRecordAndGeoGroupToXML.class)
    public String addRecordIntoNewGroup(@PayloadParam(value="poolId") String var1, @PayloadParam(value="record") DirectionalPoolRecord var2, @PayloadParam(value="group") DirectionalGroup var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="addDirectionalPoolRecord")
    @POST
    @XMLResponseParser(value=ElementTextHandler.DirectionalPoolRecordID.class)
    @MapBinder(value=DirectionalRecordAndGeoGroupToXML.class)
    public String addRecordIntoExistingGroup(@PayloadParam(value="poolId") String var1, @PayloadParam(value="record") DirectionalPoolRecord var2, @PayloadParam(value="groupId") String var3) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="addDirectionalPoolRecord")
    @POST
    @XMLResponseParser(value=ElementTextHandler.DirectionalPoolRecordID.class)
    @MapBinder(value=DirectionalRecordAndGeoGroupToXML.class)
    public String addFirstRecordInNonConfiguredGroup(@PayloadParam(value="poolId") String var1, @PayloadParam(value="record") DirectionalPoolRecord var2) throws UltraDNSWSExceptions.ResourceAlreadyExistsException;

    @Named(value="updateDirectionalPoolRecord")
    @POST
    @MapBinder(value=DirectionalRecordAndGeoGroupToXML.class)
    public void updateRecord(@PayloadParam(value="dirPoolRecordId") String var1, @PayloadParam(value="record") DirectionalPoolRecord var2) throws ResourceNotFoundException;

    @Named(value="updateDirectionalPoolRecord")
    @POST
    @MapBinder(value=DirectionalRecordAndGeoGroupToXML.class)
    public void updateRecordAndGroup(@PayloadParam(value="dirPoolRecordId") String var1, @PayloadParam(value="record") DirectionalPoolRecord var2, @PayloadParam(value="group") DirectionalGroup var3) throws ResourceNotFoundException, UltraDNSWSExceptions.DirectionalGroupOverlapException;

    @Named(value="deleteResourceRecord")
    @POST
    @Payload(value="<v01:deleteDirectionalPoolRecord><transactionID /><dirPoolRecordId>{dirPoolRecordId}</dirPoolRecordId></v01:deleteDirectionalPoolRecord>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteRecord(@PayloadParam(value="dirPoolRecordId") String var1);

    @Named(value="deleteDirectionalPool")
    @POST
    @Payload(value="<v01:deleteDirectionalPool><transactionID /><dirPoolID>{dirPoolID}</dirPoolID><retainRecordID /></v01:deleteDirectionalPool>")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PayloadParam(value="dirPoolID") String var1);
}

