/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import java.net.URI;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Task;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class TaskHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Task> {
    private StringBuilder currentText = new StringBuilder();
    private Task.Builder builder = Task.builder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task getResult() {
        try {
            Task task = this.builder.build();
            return task;
        }
        finally {
            this.builder = Task.builder();
        }
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"guid")) {
            this.builder.guid(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"code")) {
            this.builder.statusCode(Task.StatusCode.valueOf(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"message")) {
            this.builder.message(SaxUtils.currentOrNull((StringBuilder)this.currentText));
        } else if (SaxUtils.equalsOrSuffix((String)qName, (String)"resultUrl")) {
            this.builder.resultUrl(URI.create(SaxUtils.currentOrNull((StringBuilder)this.currentText)));
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

