/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ultradns.ws.xml;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.ultradns.ws.domain.Task;
import org.jclouds.ultradns.ws.xml.TaskHandler;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;

public class TaskListHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<FluentIterable<Task>> {
    private final TaskHandler taskHandler;
    private ImmutableSet.Builder<Task> tasks = ImmutableSet.builder();
    private boolean inTask;

    @Inject
    public TaskListHandler(TaskHandler taskHandler) {
        this.taskHandler = taskHandler;
    }

    public FluentIterable<Task> getResult() {
        return FluentIterable.from((Iterable)this.tasks.build());
    }

    public void startElement(String url, String name, String qName, Attributes attributes) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"taskStatus")) {
            this.inTask = true;
        }
        if (this.inTask) {
            this.taskHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"taskStatus")) {
            this.tasks.add((Object)this.taskHandler.getResult());
            this.inTask = false;
        } else if (this.inTask) {
            this.taskHandler.endElement(uri, name, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inTask) {
            this.taskHandler.characters(ch, start, length);
        }
    }
}

