/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import java.util.List;
import jena.cmd.ArgDecl;
import jena.cmd.CmdArgModule;
import jena.cmd.CmdException;
import jena.cmd.CmdGeneral;
import jena.cmd.ModBase;
import org.apache.jena.sparql.engine.main.QueryEngineMain;
import org.apache.jena.sparql.engine.main.QueryEngineMainQuad;
import org.apache.jena.sparql.engine.ref.QueryEngineRef;
import org.apache.jena.sparql.engine.ref.QueryEngineRefQuad;

public class ModEngine
extends ModBase {
    protected final ArgDecl engineDecl = new ArgDecl(true, new String[]{"engine"});
    protected final ArgDecl unEngineDecl = new ArgDecl(true, new String[]{"unengine", "unEngine", "removeEngine", "removeengine"});
    private boolean timing = false;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Query Engine");
        cmdLine.add(this.engineDecl, "--engine=EngineName", "Register another engine factory[ref]");
        cmdLine.add(this.unEngineDecl, "--unengine=EngineName", "Unregister an engine factory");
    }

    public void checkCommandLine(CmdGeneral cmdLine) {
    }

    public void processArgs(CmdArgModule cmdLine) {
        List engineDecls = cmdLine.getValues(this.engineDecl);
        block24: for (String engineName : engineDecls) {
            switch (engineName.toLowerCase()) {
                case "reference": 
                case "ref": {
                    QueryEngineRef.register();
                    continue block24;
                }
                case "refQuad": {
                    QueryEngineRefQuad.register();
                    continue block24;
                }
                case "main": {
                    QueryEngineMain.register();
                    continue block24;
                }
                case "quad": {
                    QueryEngineMainQuad.register();
                    continue block24;
                }
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
        List unEngineDecls = cmdLine.getValues(this.unEngineDecl);
        block25: for (String engineName : unEngineDecls) {
            switch (engineName.toLowerCase()) {
                case "reference": 
                case "ref": {
                    QueryEngineRef.register();
                    continue block25;
                }
                case "refQuad": {
                    QueryEngineRefQuad.register();
                    continue block25;
                }
                case "main": {
                    QueryEngineMain.register();
                    QueryEngineMainQuad.register();
                    continue block25;
                }
            }
            throw new CmdException("Engine name not recognized: " + engineName);
        }
    }
}

