/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.index;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.index.HashIndexTable;
import org.apache.jena.sparql.engine.index.IndexTable;

public class LinearIndex
implements IndexTable {
    final Set<Var> commonVars;
    List<Binding> table = new ArrayList<Binding>();

    public LinearIndex(Set<Var> commonVars, QueryIterator data) {
        this.commonVars = commonVars;
        while (data.hasNext()) {
            this.table.add((Binding)data.next());
        }
        data.close();
    }

    public LinearIndex(Set<Var> commonVars, QueryIterator data, Set<HashIndexTable.Key> loadedData, Map<Var, Integer> mappings) {
        this.commonVars = commonVars;
        for (HashIndexTable.Key key : loadedData) {
            this.table.add(LinearIndex.toBinding(key, mappings));
        }
        while (data.hasNext()) {
            this.table.add((Binding)data.next());
        }
        data.close();
    }

    @Override
    public boolean containsCompatibleWithSharedDomain(Binding bindingLeft) {
        if (this.commonVars.size() == 0) {
            return false;
        }
        for (Binding bindingRight : this.table) {
            if (!this.hasCommonVars(bindingLeft, bindingRight) || !Algebra.compatible(bindingLeft, bindingRight)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCommonVars(Binding left, Binding right) {
        for (Var v : this.commonVars) {
            if (!left.contains(v) || !right.contains(v)) continue;
            return true;
        }
        return false;
    }

    static Binding toBinding(HashIndexTable.Key key, Map<Var, Integer> mappings) {
        Node[] values = key.getNodes();
        BindingHashMap b = new BindingHashMap();
        for (Map.Entry<Var, Integer> mapping : mappings.entrySet()) {
            Node value = values[mapping.getValue()];
            if (value == null) continue;
            b.add(mapping.getKey(), value);
        }
        return b;
    }
}

