/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.iterator;

import org.apache.jena.sparql.algebra.JoinType;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.TableJoin;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.expr.ExprList;

public class QueryIterJoinBase
extends QueryIter {
    private final QueryIterator left;
    private final QueryIterator right;
    private final QueryIterator result;

    protected QueryIterJoinBase(QueryIterator left, QueryIterator right, JoinType joinType, ExprList exprs, ExecutionContext execCxt) {
        super(execCxt);
        this.left = left;
        this.right = right;
        this.result = QueryIterJoinBase.calc(left, right, joinType, exprs, execCxt);
    }

    private static QueryIterator calc(QueryIterator left, QueryIterator right, JoinType joinType, ExprList exprs, ExecutionContext execCxt) {
        Table tableRight = TableFactory.create(right);
        return TableJoin.joinWorker(left, tableRight, joinType, exprs, execCxt);
    }

    @Override
    protected boolean hasNextBinding() {
        return this.result.hasNext();
    }

    @Override
    protected Binding moveToNextBinding() {
        return this.result.nextBinding();
    }

    @Override
    protected void closeIterator() {
        this.left.close();
        this.right.close();
        this.result.close();
    }

    @Override
    protected void requestCancel() {
        this.left.cancel();
        this.right.cancel();
        this.result.cancel();
    }
}

